/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.gui.checkPPML;

import com.ice.jni.registry.Registry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.caslon.checkPPML.ManifestGenerator;
import net.caslon.checkPPML.PDFContent;
import net.caslon.gui.checkPPML.PPMLFileFilter;

public class CheckPPML
extends JFrame
implements ActionListener {
    private JTextField inputFileName;
    private JTextField preloadFileName;
    private JCheckBox showOutput;
    private JCheckBox outputManifestFile;
    private JCheckBox checkEPS;
    private JRadioButton distiller;
    private JRadioButton ghostscript;
    private JCheckBox fixProlog;
    private JComboBox memorySelector;
    private JTextField fileNameSuffix;
    private JTextField fromPage;
    private JTextField toPage;
    private JTextArea messages;
    private JTabbedPane tabs;
    private Preferences prefs = Preferences.userNodeForPackage(CheckPPML.class);

    public static void main(String[] args) {
        CheckPPML app = new CheckPPML();
    }

    public String getViewer() {
        if (System.getProperty("file.separator").equals("\\")) {
            try {
                String handler = Registry.HKEY_CLASSES_ROOT.openSubKey(".pdf").getDefaultValue();
                return Registry.HKEY_CLASSES_ROOT.openSubKey(handler).openSubKey("Shell").openSubKey("Open").openSubKey("Command").getDefaultValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    static boolean distillerInstalled() {
        PDFContent.useDistiller();
        return PDFContent.getPath() != null;
    }

    public void makeOpaque(JComponent c, boolean opaque) {
        int count = c.getComponentCount();
        c.setOpaque(opaque);
        int i = 0;
        while (i < count) {
            Component child = c.getComponent(i);
            if (!(child instanceof JTextField) && child instanceof JComponent) {
                this.makeOpaque((JComponent)child, opaque);
            }
            ++i;
        }
    }

    public CheckPPML() {
        super("CheckPPML - " + ManifestGenerator.getVersion());
        JLabel inputSection = new JLabel("Input:");
        Font normalFont = inputSection.getFont();
        Font headerFont = normalFont.deriveFont(normalFont.getSize2D() * 1.2f);
        inputSection.setFont(headerFont);
        inputSection.setAlignmentX(0.0f);
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 2));
        filePanel.setAlignmentX(0.0f);
        JLabel inputLabel = new JLabel("File:");
        inputLabel.setPreferredSize(new Dimension(60, inputLabel.getHeight()));
        this.inputFileName = new JTextField("", 30);
        JButton browseButton = new JButton("...");
        filePanel.add(Box.createRigidArea(new Dimension(10, 0)));
        filePanel.add(inputLabel);
        filePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        filePanel.add(this.inputFileName);
        filePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        filePanel.add(browseButton);
        filePanel.setMaximumSize(new Dimension(2000, (int)filePanel.getPreferredSize().getHeight()));
        JPanel preloadPanel = new JPanel();
        preloadPanel.setLayout(new BoxLayout(preloadPanel, 2));
        preloadPanel.setAlignmentX(0.0f);
        JLabel preloadLabel = new JLabel("Preload:");
        preloadLabel.setPreferredSize(new Dimension(60, preloadLabel.getHeight()));
        this.preloadFileName = new JTextField("", 30);
        JButton preloadBrowseButton = new JButton("...");
        preloadPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        preloadPanel.add(preloadLabel);
        preloadPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        preloadPanel.add(this.preloadFileName);
        preloadPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        preloadPanel.add(preloadBrowseButton);
        preloadPanel.setMaximumSize(new Dimension(2000, (int)preloadPanel.getPreferredSize().getHeight()));
        JPanel rangePanel = new JPanel();
        rangePanel.setLayout(new BoxLayout(rangePanel, 3));
        rangePanel.setAlignmentX(0.0f);
        JLabel rangeLabel = new JLabel("Print range:");
        rangeLabel.setFont(headerFont);
        JPanel rangeStartPanel = new JPanel();
        rangeStartPanel.setLayout(new BoxLayout(rangeStartPanel, 2));
        rangeStartPanel.setAlignmentX(0.0f);
        JLabel fromPageLabel = new JLabel("From:");
        this.fromPage = new JTextField(this.prefs.get("fromPage", "1"), 5);
        fromPageLabel.setPreferredSize(new Dimension(60, fromPageLabel.getHeight()));
        rangeStartPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        rangeStartPanel.add(fromPageLabel);
        rangeStartPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        rangeStartPanel.add(this.fromPage);
        rangeStartPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        rangeStartPanel.setMaximumSize(rangeStartPanel.getPreferredSize());
        JPanel rangeEndPanel = new JPanel();
        rangeEndPanel.setLayout(new BoxLayout(rangeEndPanel, 2));
        rangeEndPanel.setAlignmentX(0.0f);
        JLabel toPageLabel = new JLabel("To:");
        toPageLabel.setPreferredSize(new Dimension(60, toPageLabel.getHeight()));
        this.toPage = new JTextField(this.prefs.get("toPage", ""), 5);
        rangeEndPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        rangeEndPanel.add(toPageLabel);
        rangeEndPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        rangeEndPanel.add(this.toPage);
        rangeEndPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        rangeEndPanel.setMaximumSize(rangeEndPanel.getPreferredSize());
        rangePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        rangePanel.add(rangeLabel);
        rangePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        rangePanel.add(rangeStartPanel);
        rangePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        rangePanel.add(rangeEndPanel);
        rangePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 3));
        inputPanel.setAlignmentX(0.0f);
        inputPanel.add(inputSection);
        inputPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        inputPanel.add(filePanel);
        inputPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        inputPanel.add(preloadPanel);
        inputPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        inputPanel.add(rangePanel);
        JButton convertButton = new JButton("Convert");
        convertButton.setAlignmentX(0.0f);
        inputPanel.add(Box.createVerticalGlue());
        inputPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        inputPanel.add(convertButton);
        inputPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel CompanyLogo = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("logos/Caslon-logo.gif"), "Caslon logo"));
        CompanyLogo.setBorder(BorderFactory.createEmptyBorder(10, 15, 5, 20));
        CompanyLogo.setAlignmentX(0.0f);
        JLabel PPMLLogo = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("logos/PPMLlogo.gif"), "PPML logo"));
        PPMLLogo.setAlignmentX(0.0f);
        PPMLLogo.setBorder(BorderFactory.createEmptyBorder(5, 45, 10, 45));
        JPanel logoPanel = new JPanel();
        logoPanel.setLayout(new BoxLayout(logoPanel, 3));
        logoPanel.setAlignmentX(0.0f);
        logoPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        logoPanel.add(CompanyLogo);
        logoPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        logoPanel.add(Box.createVerticalGlue());
        logoPanel.add(PPMLLogo);
        logoPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        logoPanel.setBackground(Color.white);
        logoPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel logoContainer = new JPanel();
        logoContainer.setLayout(new BoxLayout(logoContainer, 3));
        logoContainer.setAlignmentX(0.0f);
        if (ManifestGenerator.isMac) {
            logoContainer.setBorder(BorderFactory.createEmptyBorder(15, 5, 10, 10));
        }
        logoContainer.add(logoPanel);
        JLabel ps2pdfLabel = new JLabel("PostScript to PDF converter:");
        ps2pdfLabel.setFont(headerFont);
        ps2pdfLabel.setAlignmentX(0.0f);
        boolean hasDistiller = this.prefs.getBoolean("useDistiller", CheckPPML.distillerInstalled() | ManifestGenerator.isMac);
        this.distiller = new JRadioButton(ManifestGenerator.isMac ? "Built-in" : "Distiller", hasDistiller);
        this.distiller.setAlignmentX(0.0f);
        this.ghostscript = new JRadioButton("GhostScript", !hasDistiller);
        this.ghostscript.setAlignmentX(0.0f);
        this.checkEPS = new JCheckBox("Strict EPS checking", false);
        this.checkEPS.setAlignmentX(0.0f);
        this.fixProlog = new JCheckBox("Convert ProcSet to Prolog", false);
        this.fixProlog.setAlignmentX(0.0f);
        this.distiller.addActionListener(this);
        this.distiller.setActionCommand("useDistiller");
        this.ghostscript.addActionListener(this);
        this.ghostscript.setActionCommand("useGhostScript");
        this.checkEPS.addActionListener(this);
        this.checkEPS.setActionCommand("checkEPS");
        this.fixProlog.addActionListener(this);
        this.fixProlog.setActionCommand("fixProlog");
        JLabel outputSection = new JLabel("Output:");
        outputSection.setFont(headerFont);
        outputSection.setAlignmentX(0.0f);
        this.showOutput = new JCheckBox("Launch viewer", this.prefs.getBoolean("launchViewer", true));
        this.showOutput.setAlignmentX(0.0f);
        this.showOutput.addActionListener(this);
        this.showOutput.setActionCommand("changeLaunchViewer");
        this.outputManifestFile = new JCheckBox("Generate manifest", this.prefs.getBoolean("generateManifest", false));
        this.outputManifestFile.setAlignmentX(0.0f);
        this.outputManifestFile.addActionListener(this);
        this.outputManifestFile.setActionCommand("changeGenerateManifest");
        JLabel suffixLabel = new JLabel("Suffix:");
        suffixLabel.setPreferredSize(new Dimension(60, suffixLabel.getHeight()));
        this.fileNameSuffix = new JTextField(this.prefs.get("outputSuffix", "-output"), 20);
        JPanel suffixPanel = new JPanel();
        suffixPanel.setLayout(new BoxLayout(suffixPanel, 2));
        suffixPanel.setAlignmentX(0.0f);
        suffixPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        suffixPanel.add(suffixLabel);
        suffixPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        suffixPanel.add(this.fileNameSuffix);
        suffixPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        suffixPanel.setMaximumSize(suffixPanel.getPreferredSize());
        JLabel memorySection = new JLabel("Memory:");
        memorySection.setFont(headerFont);
        memorySection.setAlignmentX(0.0f);
        String[] sizes = new String[]{"Default", "256m", "512m", "1024m", "1536m", "2048m"};
        this.memorySelector = new JComboBox<String>(sizes);
        this.memorySelector.setSelectedItem(this.prefs.get("memorySize", sizes[0]));
        this.memorySelector.setActionCommand("setMemory");
        this.memorySelector.addActionListener(this);
        JLabel memoryLabel = new JLabel("Size:");
        memoryLabel.setPreferredSize(new Dimension(60, memoryLabel.getHeight()));
        JPanel memoryPanel = new JPanel();
        memoryPanel.setLayout(new BoxLayout(memoryPanel, 2));
        memoryPanel.setAlignmentX(0.0f);
        memoryPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        memoryPanel.add(memoryLabel);
        memoryPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        memoryPanel.add(this.memorySelector);
        memoryPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        memoryPanel.setMaximumSize(memoryPanel.getPreferredSize());
        JPanel setupPanel = new JPanel();
        setupPanel.setLayout(new BoxLayout(setupPanel, 3));
        setupPanel.setAlignmentX(0.0f);
        setupPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        setupPanel.add(ps2pdfLabel);
        setupPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        setupPanel.add(this.distiller);
        setupPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        setupPanel.add(this.ghostscript);
        setupPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        setupPanel.add(this.checkEPS);
        setupPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        setupPanel.add(this.fixProlog);
        setupPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        setupPanel.add(outputSection);
        setupPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        setupPanel.add(this.showOutput);
        setupPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        setupPanel.add(this.outputManifestFile);
        setupPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        setupPanel.add(suffixPanel);
        setupPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        setupPanel.add(memorySection);
        setupPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        setupPanel.add(memoryPanel);
        setupPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.messages = new JTextArea();
        this.messages.setEditable(false);
        this.messages.setLineWrap(true);
        JPanel messagesPanel = new JPanel();
        messagesPanel.setLayout(new BoxLayout(messagesPanel, 3));
        messagesPanel.setAlignmentX(0.0f);
        messagesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        messagesPanel.add(new JScrollPane(this.messages));
        this.makeOpaque(setupPanel, false);
        this.makeOpaque(inputPanel, false);
        this.makeOpaque(messagesPanel, false);
        this.tabs = new JTabbedPane();
        this.tabs.addTab("Conversion", inputPanel);
        this.tabs.addTab("Setup", setupPanel);
        this.tabs.addTab("Messages", messagesPanel);
        JPanel content = new JPanel();
        this.setContentPane(content);
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        BoxLayout layout = new BoxLayout(content, 2);
        content.setLayout(layout);
        this.setResizable(true);
        content.add(this.tabs);
        content.add(Box.createRigidArea(new Dimension(5, 0)));
        content.add(logoContainer);
        content.setMinimumSize(content.getPreferredSize());
        preloadBrowseButton.setActionCommand("preloadBrowse");
        preloadBrowseButton.addActionListener(this);
        browseButton.setActionCommand("inputBrowse");
        browseButton.addActionListener(this);
        convertButton.setActionCommand("convert");
        convertButton.addActionListener(this);
        this.pack();
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CheckPPML.this.setVisible(false);
                CheckPPML.this.dispose();
                System.exit(0);
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("changeLaunchViewer")) {
            this.prefs.putBoolean("launchViewer", this.showOutput.isSelected());
        } else if (action.equals("changeGenerateManifest")) {
            this.prefs.putBoolean("generateManifest", this.outputManifestFile.isSelected());
        } else if (action.equals("useDistiller")) {
            this.ghostscript.setSelected(false);
            this.distiller.setSelected(true);
            this.prefs.putBoolean("useDistiller", true);
        } else if (action.equals("useGhostScript")) {
            this.distiller.setSelected(false);
            this.ghostscript.setSelected(true);
            this.prefs.putBoolean("useDistiller", false);
        } else if (action.equals("setMemory")) {
            this.prefs.put("memorySize", (String)this.memorySelector.getSelectedItem());
        } else if (action.equals("checkEPS")) {
            this.prefs.putBoolean("checkEPS", this.checkEPS.isSelected());
        } else if (action.equals("fixProlog")) {
            this.prefs.putBoolean("fixProlog", this.fixProlog.isSelected());
        } else if (action.equals("inputBrowse")) {
            File fileName;
            String dir = this.prefs.get("lastDir", this.inputFileName.getText());
            if (dir == null || dir.length() == 0) {
                dir = this.preloadFileName.getText();
            }
            if (dir == null || dir.length() == 0) {
                dir = ".";
            }
            JFileChooser browse = new JFileChooser(dir);
            browse.setDialogTitle("Input PPML File");
            browse.addChoosableFileFilter(new PPMLFileFilter());
            if (browse.showOpenDialog(this) == 0 && (fileName = browse.getSelectedFile()) != null) {
                this.inputFileName.setText(fileName.toString());
                this.prefs.put("lastDir", fileName.toString());
            }
        } else if (action.equals("preloadBrowse")) {
            File fileName;
            String dir = this.prefs.get("lastPreloadDir", this.preloadFileName.getText());
            if (dir == null || dir.length() == 0) {
                dir = this.inputFileName.getText();
            }
            if (dir == null || dir.length() == 0) {
                dir = ".";
            }
            JFileChooser browse = new JFileChooser(dir);
            browse.setDialogTitle("Preload PPML File");
            browse.addChoosableFileFilter(new PPMLFileFilter());
            if (browse.showOpenDialog(this) == 0 && (fileName = browse.getSelectedFile()) != null) {
                this.preloadFileName.setText(fileName.toString());
                this.prefs.put("lastPreloadDir", fileName.toString());
            }
        } else if (action.equals("convert") || action.equals("debugconvert") || action.equals("skipconvert")) {
            Cursor old;
            block57: {
                String baseName;
                File pdfFile;
                old = this.getCursor();
                this.messages.removeAll();
                try {
                    this.prefs.sync();
                }
                catch (Exception browse) {
                    // empty catch block
                }
                String fileName = this.inputFileName.getText();
                if (fileName.length() == 0) {
                    return;
                }
                int index = fileName.lastIndexOf(46);
                if (index < 0) {
                    index = fileName.length();
                }
                if ((pdfFile = new File(String.valueOf(baseName = String.valueOf(fileName.substring(0, index)) + this.fileNameSuffix.getText()) + ".pdf")).exists()) {
                    pdfFile.delete();
                }
                try {
                    Vector<String> args = new Vector<String>();
                    args.add("java");
                    if (this.memorySelector.getSelectedIndex() > 0) {
                        args.add("-Xmx" + this.memorySelector.getSelectedItem());
                    }
                    if (ManifestGenerator.isMac) {
                        args.add("-Xdock:name=CheckPPML");
                    }
                    args.add("-jar");
                    args.add(String.valueOf(ManifestGenerator.getInstallationPath()) + System.getProperty("file.separator") + "manifest.jar");
                    args.add("-pdf");
                    args.add(String.valueOf(baseName) + ".pdf");
                    if (this.outputManifestFile.isSelected()) {
                        args.add("-o");
                        args.add(String.valueOf(baseName) + "-manifest.xml");
                    }
                    if (action.equals("debugconvert")) {
                        args.add("-debug");
                    }
                    if (action.equals("skipconvert")) {
                        args.add("-skip");
                    }
                    args.add("-s");
                    args.add(new File(baseName).getParent());
                    if (this.preloadFileName.getText().length() > 0) {
                        args.add(this.preloadFileName.getText());
                    }
                    if (this.distiller.isSelected()) {
                        if (!ManifestGenerator.isMac) {
                            args.add("-distiller");
                        }
                    } else if (ManifestGenerator.isMac) {
                        args.add("-gs");
                    }
                    if (this.checkEPS.isSelected()) {
                        args.add("-checkEPS");
                    }
                    if (this.fixProlog.isSelected()) {
                        args.add("-fixprolog");
                    }
                    args.add("-from");
                    args.add(this.fromPage.getText());
                    if (this.toPage.getText().length() > 0) {
                        args.add("-to");
                        args.add(this.toPage.getText());
                    }
                    args.add("-log");
                    args.add(String.valueOf(baseName) + ".log");
                    args.add(this.inputFileName.getText());
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        Process p = Runtime.getRuntime().exec(args.toArray(new String[0]));
                        int exitCode = p.waitFor();
                        if (exitCode != 0) {
                            this.message("Conversion terminated abnormally with exit code " + exitCode);
                        }
                    }
                    catch (Exception p) {
                        // empty catch block
                    }
                    if (new File(String.valueOf(baseName) + ".log").length() > 0L) {
                        FileReader messagesFile = new FileReader(String.valueOf(baseName) + ".log");
                        this.messages.read(messagesFile, null);
                        messagesFile.close();
                        this.tabs.setSelectedIndex(2);
                    }
                    if (!this.showOutput.isSelected() || !pdfFile.exists()) break block57;
                    try {
                        String[] cmd;
                        if (this.runningOnWindows()) {
                            cmd = this.getViewer();
                            if (cmd != null) {
                                Runtime.getRuntime().exec(cmd.replaceAll("%1", String.valueOf(baseName.replaceAll("\\\\", "\\\\\\\\")) + ".pdf"));
                            } else {
                                this.message("No viewer detected");
                            }
                            break block57;
                        }
                        if (ManifestGenerator.isMac) {
                            cmd = new String[]{"/usr/bin/open", String.valueOf(baseName) + ".pdf"};
                            Runtime.getRuntime().exec(cmd);
                            break block57;
                        }
                        Runtime.getRuntime().exec("acroread " + baseName + ".pdf");
                    }
                    catch (Exception exception) {
                        this.message("Failed to execute viewer for " + baseName + ".pdf: " + exception);
                    }
                }
                catch (Throwable exception) {
                    try {
                        FileReader messagesFile = new FileReader(String.valueOf(baseName) + ".log");
                        this.messages.read(messagesFile, null);
                        messagesFile.close();
                        this.tabs.setSelectedIndex(2);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    this.message("Conversion failed: " + exception);
                }
            }
            this.setCursor(old);
        }
    }

    public void message(String msg) {
        JDialog box = new JDialog(this, "Alert", true);
        Container content = box.getContentPane();
        BoxLayout layout = new BoxLayout(content, 3);
        content.setLayout(layout);
        this.setResizable(true);
        JLabel label = new JLabel(msg, 0);
        label.setAlignmentX(0.5f);
        JButton okButton = new JButton("OK");
        okButton.setAlignmentX(0.5f);
        content.add(Box.createRigidArea(new Dimension(0, 5)));
        content.add(label);
        content.add(Box.createVerticalGlue());
        content.add(Box.createRigidArea(new Dimension(0, 5)));
        content.add(okButton);
        content.add(Box.createRigidArea(new Dimension(0, 5)));
        okButton.setActionCommand("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Window)((JButton)e.getSource()).getTopLevelAncestor()).dispose();
            }
        });
        box.pack();
        this.setResizable(false);
        box.setVisible(true);
    }

    private boolean runningOnWindows() {
        return System.getProperty("file.separator").equals("\\");
    }
}

