/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.Iterator;

public class PdfImportedPage
extends PdfTemplate {
    PdfReaderInstance readerInstance;
    int pageNumber;

    PdfImportedPage(PdfReaderInstance pdfReaderInstance, PdfWriter pdfWriter, int n) {
        super(pdfWriter);
        this.readerInstance = pdfReaderInstance;
        this.pageNumber = n;
        this.thisReference = pdfWriter.getPdfIndirectReference();
        this.bBox = pdfReaderInstance.getReader().getPageSize(n);
        this.setMatrix(1.0f, 0.0f, 0.0f, 1.0f, -this.bBox.getLeft(), -this.bBox.getBottom());
        this.type = 2;
    }

    public PdfImportedPage getFromReader() {
        return this;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void addImage(Image image, float f, float f2, float f3, float f4, float f5, float f6) throws DocumentException {
        this.throwError();
    }

    public void addTemplate(PdfTemplate pdfTemplate, float f, float f2, float f3, float f4, float f5, float f6) {
        this.throwError();
    }

    public PdfContentByte getDuplicate() {
        this.throwError();
        return null;
    }

    PdfStream getFormXObject(int n) throws IOException {
        PdfStream pdfStream = this.readerInstance.getFormXObject(this.pageNumber, n);
        if (this.group != null) {
            pdfStream.put(PdfName.GROUP, this.group);
        }
        PdfDictionary pdfDictionary = this.pageResources.colorDictionary;
        PdfDictionary pdfDictionary2 = pdfStream.getAsDict(PdfName.RESOURCES);
        PdfDictionary pdfDictionary3 = pdfDictionary2.getAsDict(PdfName.COLORSPACE);
        if (pdfDictionary3 == null) {
            pdfDictionary3 = new PdfDictionary();
            pdfDictionary2.put(PdfName.COLORSPACE, pdfDictionary3);
        }
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            if (pdfDictionary3.contains(pdfName)) continue;
            pdfDictionary3.put(pdfName, pdfDictionary.get(pdfName));
        }
        return pdfStream;
    }

    public void setColorFill(PdfSpotColor pdfSpotColor, float f) {
        this.throwError();
    }

    public void setColorStroke(PdfSpotColor pdfSpotColor, float f) {
        this.throwError();
    }

    PdfObject getResources() {
        return this.readerInstance.getResources(this.pageNumber);
    }

    public void setFontAndSize(BaseFont baseFont, float f) {
        this.throwError();
    }

    void throwError() {
        throw new RuntimeException("Content can not be added to a PdfImportedPage.");
    }

    PdfReaderInstance getPdfReaderInstance() {
        return this.readerInstance;
    }
}

