/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.IOException;
import net.caslon.checkPPML.ImpositionObject;
import net.caslon.checkPPML.Object;
import net.caslon.checkPPML.OrderExpression;
import net.caslon.checkPPML.PDFOutput;
import net.caslon.checkPPML.Parser;
import net.caslon.checkPPML.Scope;

public class Cell
implements ImpositionObject {
    private boolean front;
    private AffineTransform transform;
    private Area clipPath;
    private OrderExpression pageOrder;
    private OrderExpression docOrder;

    public Cell(boolean front, AffineTransform transform, Area clipPath, OrderExpression pageOrder, OrderExpression docOrder) {
        this.front = front;
        this.transform = transform;
        this.clipPath = clipPath;
        this.pageOrder = pageOrder;
        this.docOrder = docOrder;
    }

    public ImpositionObject copy(float dx, float dy) {
        return this.copy(AffineTransform.getTranslateInstance(dx, dy));
    }

    public ImpositionObject copy(float dx, float dy, OrderExpression replaceN, OrderExpression replaceS, OrderExpression docOffset) {
        Cell c = (Cell)this.copy(AffineTransform.getTranslateInstance(dx, dy));
        if (replaceN != null) {
            c.docOrder.replaceN(replaceN);
        }
        if (replaceS != null) {
            c.docOrder.replaceS(replaceS);
        }
        if (docOffset != null) {
            c.docOrder.add(docOffset);
        }
        return c;
    }

    public ImpositionObject copy(AffineTransform transform) {
        AffineTransform t = new AffineTransform(this.transform);
        t.preConcatenate(transform);
        Area a = new Area(this.clipPath);
        a.transform(transform);
        return new Cell(this.front, t, a, this.pageOrder, this.docOrder);
    }

    public ImpositionObject copy() {
        return new Cell(this.front, this.transform, this.clipPath, this.pageOrder, this.docOrder);
    }

    public boolean onUpFace() {
        return this.front;
    }

    public int getPageNr(int s, int n) {
        return this.pageOrder.calculate(s, n);
    }

    public int getDocNr(int s, int n) {
        return this.docOrder.calculate(s, n);
    }

    public void displayPage(PDFOutput output, Parser parser, Scope page) throws IOException {
        output.save();
        output.setupClip(this.clipPath);
        output.setupTransform(this.transform);
        int objects = page.getNrOfChildren();
        int i = 0;
        while (i < objects) {
            Object o = (Object)page.getChild(i);
            parser.placeObject(output, o);
            ++i;
        }
        output.restore();
    }
}

