/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import net.caslon.checkPPML.ImageContent;
import net.caslon.checkPPML.PDFContent;
import net.caslon.checkPPML.PDFOutput;

public class CombinePDF {
    public static void main(String[] args) throws Exception {
        PDFOutput output = new PDFOutput("Combined", args[0]);
        AffineTransform identity = new AffineTransform();
        File folder = new File(args[1]);
        CombinePDF.generateOutput(folder, output, identity);
        output.close();
    }

    private static void generateOutput(File folder, PDFOutput output, AffineTransform identity) throws IOException {
        if (folder.isFile()) {
            if (folder.getName().equals(".DS_Store")) {
                return;
            }
            if (folder.getName().equals("Thumbs.db")) {
                return;
            }
            output.startPage(595.0f, 842.0f);
            String fileName = folder.getAbsolutePath();
            String suffix = fileName.substring(fileName.lastIndexOf(46) + 1);
            if ("pdf".equals(suffix)) {
                PDFContent pdf = new PDFContent(output, fileName, 1, "CMYK");
                pdf.display(output, identity);
                int nrOfPages = pdf.nrOfPages;
                int j = 2;
                while (j < nrOfPages) {
                    output.startPage(595.0f, 842.0f);
                    pdf.setPage(j, 0.0f, 0.0f);
                    pdf.display(output, identity);
                    ++j;
                }
            } else {
                String mimetype = "jpg".equals(suffix) ? "image/jpeg" : ("tiff".equals(suffix) ? "image/tiff" : null);
                ImageContent image = new ImageContent(fileName, mimetype, 1, 595.0f, 842.0f, "CMYK");
                image.display(output, identity);
                int nrOfPages = image.nrOfPages;
                int j = 2;
                while (j < nrOfPages) {
                    output.startPage(595.0f, 842.0f);
                    image.setPage(j, 595.0f, 842.0f);
                    image.display(output, identity);
                    ++j;
                }
            }
        } else {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                CombinePDF.generateOutput(file, output, identity);
                ++n2;
            }
        }
    }
}

