/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import com.lowagie.text.pdf.PdfTemplate;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Iterator;
import net.caslon.checkPPML.Content;
import net.caslon.checkPPML.Object;
import net.caslon.checkPPML.PDFOutput;
import net.caslon.checkPPML.Parser;

public class CompoundContent
implements Content {
    PdfTemplate content;

    public CompoundContent(PDFOutput output, Object group, Parser parser) throws IOException {
        this.content = output.createTemplate(group.isIsolated(), group.isKnockout(), group.getBlendColorSpace(), group.getBBox());
        PDFOutput groupOutput = output.getOutput(this.content);
        groupOutput.setupTransform(group.getTransform());
        Iterator i = group.getObjects();
        while (i.hasNext()) {
            Object object = (Object)i.next();
            if (object.isRef()) {
                parser.placeObject(groupOutput, object);
                continue;
            }
            if (object.isGroup()) {
                parser.placeGroup(groupOutput, object);
                continue;
            }
            parser.placeObject(groupOutput, object);
        }
        groupOutput.releaseTemplate(this.content);
    }

    public void display(PDFOutput device, AffineTransform transform) throws IOException {
        device.place(this.content, transform);
    }

    public Content create(int pageNr, float width, float height, String blendColorSpace) throws IOException {
        throw new IOException("Can't change page number on a group");
    }

    public void setPage(int pageNr, float width, float height) throws IOException {
        throw new IOException("Can't change page number on a group");
    }

    public boolean hasDimensions() {
        return true;
    }

    public float getWidth() {
        return this.content.getWidth();
    }

    public float getHeight() {
        return this.content.getHeight();
    }

    public PdfTemplate getReusableContent(PDFOutput device, String blendColorSpace) throws IOException {
        return this.content;
    }
}

