/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.io.IOException;
import net.caslon.checkPPML.Occurrence;
import net.caslon.checkPPML.Resource;
import net.caslon.checkPPML.Scope;
import net.caslon.checkPPML.XMLWriter;

public class GlobalScope
extends Scope {
    public GlobalScope() {
        super(null, "GLOBAL", "Global", null);
    }

    public void addOccurrence(String name, String environment, String scope, Occurrence object) {
        if (scope == null || scope.equals(this.scope)) {
            if (environment == null) {
                throw new RuntimeException("Environment must be specified when defining a global object");
            }
        } else {
            throw new RuntimeException("Unknown scope " + scope + " specified");
        }
        this.objects.put("<" + environment + ">" + name, object);
    }

    public void removeOccurrence(String name, String environment) {
        this.objects.remove("<" + environment + ">" + name);
    }

    public Occurrence findOccurrence(String name, String environment) {
        return (Occurrence)this.objects.get("<" + environment + ">" + name);
    }

    public void addResource(Resource resource, String name, String environment, String scope) {
        if (scope == null || scope.equals(this.scope)) {
            if (environment == null) {
                throw new RuntimeException("Environment must be specified when defining a global resource");
            }
        } else {
            throw new RuntimeException("Unknown scope " + scope + " specified");
        }
        this.resources.put("<" + environment + ">" + name, resource);
    }

    public void removeResource(String name, String environment) {
        this.resources.remove("<" + environment + ">" + name);
    }

    public Resource findResource(String name, String environment) {
        return (Resource)this.resources.get("<" + environment + ">" + name);
    }

    public void write(XMLWriter stream) throws IOException {
        int i = 0;
        while (i < this.children.size()) {
            Scope child = (Scope)this.children.get(i);
            child.write(stream);
            ++i;
        }
    }
}

