/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfTemplate;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageInputStream;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.caslon.checkPPML.Content;
import net.caslon.checkPPML.PDFOutput;
import org.w3c.dom.Element;

public class ImageContent
implements Content {
    int nrOfPages;
    int pageNr;
    String fileName;
    float width;
    float height;
    Image image;
    String type;
    boolean dimensionsSpecified;
    String blendColorSpace;
    PdfTemplate cachedImage;

    public ImageContent(String fileName, String mimetype, int pageNr, float width, float height, String blendColorSpace) throws IOException {
        if (mimetype.equals("image/tiff")) {
            this.type = mimetype;
        } else if (mimetype.equals("image/jpeg")) {
            this.type = mimetype;
        } else {
            throw new IOException("Unsupported image format " + mimetype);
        }
        this.fileName = fileName;
        this.blendColorSpace = blendColorSpace;
        this.setPage(pageNr, width, height);
    }

    public Content create(int pageNr, float width, float height, String blendColorSpace) throws IOException {
        return new ImageContent(this.fileName, this.type, pageNr, width, height, blendColorSpace);
    }

    private int decodeShort(byte c1, byte c2) {
        int value = c1 < 0 ? c1 + 256 : c1;
        value <<= 8;
        value = c2 < 0 ? (value |= c2 + 256) : (value |= c2);
        return value;
    }

    /*
     * Unable to fully structure code
     */
    public void setPage(int pageNr, float width, float height) throws IOException {
        fileInfo = new File(this.fileName);
        stream = new FileImageInputStream(fileInfo);
        try {
            decoder = null;
            it = ImageIO.getImageReadersByMIMEType(this.type);
            if (it != null) ** GOTO lbl17
            throw new IOException("Images of type " + this.type + " are not supported");
lbl-1000:
            // 1 sources

            {
                decoder = it.next();
                try {
                    decoder.setInput(stream);
                    this.nrOfPages = decoder.getNumImages(true);
                }
                catch (Throwable t) {
                    System.err.println("Error reading image:" + t);
                    this.nrOfPages = 0;
                }
                if (this.nrOfPages > 0) break;
lbl17:
                // 2 sources

                ** while (it.hasNext())
            }
lbl18:
            // 2 sources

            if (decoder == null) {
                throw new IOException("Images of type " + this.type + " are not supported");
            }
            if (this.nrOfPages <= 0) {
                throw new IOException("Error reading image");
            }
            if (pageNr < 0 && this.nrOfPages != 1) {
                throw new IOException("Image file " + this.fileName + " has " + this.nrOfPages + " pages in stead of the expected 1");
            }
            if (pageNr == 0) {
                throw new IOException("Index " + pageNr + " is out of range, image file " + this.fileName + " has " + this.nrOfPages + " pages");
            }
            this.pageNr = pageNr < 0 ? 1 : pageNr;
            this.width = width;
            this.height = height;
            this.dimensionsSpecified = false;
            if (this.pageNr > this.nrOfPages) {
                this.image = null;
                return;
            }
            try {
                bufferedImage = decoder.read(this.pageNr - 1);
                try {
                    metadata = decoder.getImageMetadata(this.pageNr - 1);
                    metadataTree = metadata.getAsTree(metadata.getNativeMetadataFormatName());
                    factory = XPathFactory.newInstance();
                    xpath = factory.newXPath();
                    if (this.type.equals("image/tiff") && metadataTree != null) {
                        unit = (String)xpath.evaluate("//TIFFField[@Number='296']/TIFFShorts/TiffShort[0]/@Value", metadataTree, XPathConstants.STRING);
                        if (unit == null || !unit.equals("1")) {
                            xres = (Double)xpath.evaluate("//TIFFField[@Number='282']/TIFFRationals/TiffRational[0]/@Value", metadataTree, XPathConstants.NUMBER);
                            yres = (Double)xpath.evaluate("//TIFFField[@Number='283']/TIFFRationals/TiffRational[0]/@Value", metadataTree, XPathConstants.NUMBER);
                            if (unit.equals("2")) {
                                this.width = (float)bufferedImage.getWidth() * 72.0f / xres.floatValue();
                                this.height = (float)bufferedImage.getHeight() * 72.0f / yres.floatValue();
                                this.dimensionsSpecified = true;
                            } else if (unit.equals("3")) {
                                this.width = (float)bufferedImage.getWidth() * 72.0f * 2.54f / xres.floatValue();
                                this.height = (float)bufferedImage.getHeight() * 72.0f * 2.54f / yres.floatValue();
                                this.dimensionsSpecified = true;
                            }
                        }
                    } else if (this.type.equals("image/jpeg") && metadataTree != null && (jfif = (Element)xpath.evaluate("//app0JFIF", metadataTree, XPathConstants.NODE)) != null) {
                        unit = Integer.parseInt(jfif.getAttribute("resUnits"));
                        xres = Integer.parseInt(jfif.getAttribute("Xdensity"));
                        yres = Integer.parseInt(jfif.getAttribute("Ydensity"));
                        if (unit == 1) {
                            this.width = (float)bufferedImage.getWidth() * 72.0f / (float)xres;
                            this.height = (float)bufferedImage.getHeight() * 72.0f / (float)yres;
                            this.dimensionsSpecified = true;
                        } else if (unit == 2) {
                            this.width = (float)bufferedImage.getWidth() * 72.0f * 2.54f / (float)xres;
                            this.height = (float)bufferedImage.getHeight() * 72.0f * 2.54f / (float)yres;
                            this.dimensionsSpecified = true;
                        }
                    }
                }
                catch (Exception var9_12) {
                    // empty catch block
                }
                this.image = this.createRawImage(bufferedImage);
                this.image.setAbsolutePosition(0.0f, 0.0f);
                this.image.scaleAbsolute(this.width, this.height);
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
                throw new IOException("Error reading image " + this.fileName + ": " + e);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private Image createRawImage(BufferedImage bufferedImage) throws Exception {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int components = bufferedImage.getColorModel().getNumColorComponents();
        int bpc = bufferedImage.getColorModel().getComponentSize(0);
        int range = 1;
        while (bpc >= 1) {
            --bpc;
            range *= 2;
        }
        --range;
        byte[] data = new byte[width * height * components];
        Raster raster = bufferedImage.getData();
        int pos = 0;
        int[] pixel = new int[components + 1];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                raster.getPixel(x, y, pixel);
                int c = 0;
                while (c < components) {
                    data[pos] = (byte)Math.round(pixel[c] * 255 / range);
                    ++c;
                    ++pos;
                }
                ++x;
            }
            ++y;
        }
        return Image.getInstance(width, height, components, 8, data);
    }

    public PdfTemplate getReusableContent(PDFOutput device, String blendColorSpace) throws IOException {
        if (this.cachedImage == null && this.image != null) {
            this.cachedImage = device.makeReusable(this.width, this.height, this, blendColorSpace);
            this.image = null;
        }
        return this.cachedImage;
    }

    public void display(PDFOutput device, AffineTransform transform) throws IOException {
        if (this.cachedImage != null) {
            device.place(this.cachedImage, transform);
        } else if (this.image != null) {
            device.place(this.image, transform);
        }
    }

    public boolean hasDimensions() {
        return this.dimensionsSpecified;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }
}

