/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Vector;
import net.caslon.checkPPML.Cell;
import net.caslon.checkPPML.ImpositionObject;
import net.caslon.checkPPML.OrderExpression;
import net.caslon.checkPPML.PDFOutput;
import net.caslon.checkPPML.Parser;
import net.caslon.checkPPML.Scope;
import net.caslon.checkPPML.SheetMark;

public class ImpositionTemplate {
    private float width = 0.0f;
    private float height = 0.0f;
    private int documentsPerGroup = 1;
    private int pagesPerSheet = 0;
    private int repeatCount = 1;
    private Vector impositionObjects = new Vector();
    private int nrOfCells = 0;
    private int setCopies = 1;
    private int docCopies = 1;
    private int sheetCopies = 1;
    private boolean gangDocuments = false;
    public static final int COLLATE_NO = 0;
    public static final int COLLATE_DOCUMENT = 1;
    public static final int COLLATE_DOCSET = 2;

    public void setCopies(int nCopies, int collate) {
        this.setCopies = 1;
        this.docCopies = 1;
        this.sheetCopies = 1;
        switch (collate) {
            case 0: {
                this.sheetCopies = nCopies;
                break;
            }
            case 1: {
                this.docCopies = nCopies;
                break;
            }
            case 2: {
                this.setCopies = nCopies;
            }
        }
    }

    public void setPagesPerSheet(int pagesPerSheet) {
        this.pagesPerSheet = pagesPerSheet;
    }

    public void gangDocumentsPerSet() {
        this.gangDocuments = true;
    }

    public int getNrOfCells() {
        return this.nrOfCells;
    }

    public ImpositionTemplate repeatVertically(float offset, int count, boolean duplicate, boolean ascending) {
        OrderExpression replaceN;
        ImpositionTemplate result = new ImpositionTemplate();
        result.width = this.width;
        result.height = (float)count * offset;
        result.repeatCount = this.repeatCount;
        result.documentsPerGroup = duplicate ? this.documentsPerGroup : this.documentsPerGroup * count;
        result.pagesPerSheet = this.pagesPerSheet;
        result.nrOfCells = this.nrOfCells * count;
        try {
            replaceN = OrderExpression.parse("n/" + count);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        int i = 0;
        while (i < count) {
            OrderExpression docOffset = OrderExpression.constant(ascending ? this.documentsPerGroup * i : this.documentsPerGroup * (count - i - 1));
            for (ImpositionObject o : this.impositionObjects) {
                if (duplicate || !(o instanceof Cell)) {
                    result.impositionObjects.add(o.copy(0.0f, offset * (float)i));
                    continue;
                }
                Cell c = (Cell)o;
                result.impositionObjects.add(c.copy(0.0f, offset * (float)i, replaceN, null, docOffset));
            }
            ++i;
        }
        return result;
    }

    public ImpositionTemplate repeatHorizontally(float offset, int count, boolean duplicate, boolean ascending) {
        OrderExpression replaceN;
        ImpositionTemplate result = new ImpositionTemplate();
        result.width = (float)count * offset;
        result.height = this.height;
        result.repeatCount = this.repeatCount;
        result.pagesPerSheet = this.pagesPerSheet;
        result.nrOfCells = this.nrOfCells * count;
        result.documentsPerGroup = duplicate ? this.documentsPerGroup : this.documentsPerGroup * count;
        try {
            replaceN = OrderExpression.parse("n/" + count);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        int i = 0;
        while (i < count) {
            OrderExpression docOffset = OrderExpression.constant(ascending ? this.documentsPerGroup * i : this.documentsPerGroup * (count - i - 1));
            for (ImpositionObject o : this.impositionObjects) {
                if (duplicate || !(o instanceof Cell)) {
                    result.impositionObjects.add(o.copy(offset * (float)i, 0.0f));
                    continue;
                }
                Cell c = (Cell)o;
                result.impositionObjects.add(c.copy(offset * (float)i, 0.0f, replaceN, null, docOffset));
            }
            ++i;
        }
        return result;
    }

    public ImpositionTemplate repeatStacked(int count, boolean duplicate, boolean ascending) {
        OrderExpression docOffset;
        OrderExpression replaceS;
        OrderExpression replaceN;
        ImpositionTemplate result = new ImpositionTemplate();
        result.width = this.width;
        result.height = this.height;
        result.repeatCount = this.repeatCount * count;
        result.pagesPerSheet = this.pagesPerSheet;
        result.nrOfCells = this.nrOfCells;
        result.documentsPerGroup = duplicate ? this.documentsPerGroup : this.documentsPerGroup * count;
        try {
            replaceN = OrderExpression.parse("n/" + count);
            replaceS = OrderExpression.parse("s%" + this.repeatCount);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        try {
            docOffset = ascending ? OrderExpression.parse("s/" + this.repeatCount) : OrderExpression.parse(String.valueOf(count) + "-s/" + this.repeatCount + "-1");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        for (ImpositionObject o : this.impositionObjects) {
            if (duplicate || !(o instanceof Cell)) {
                result.impositionObjects.add(o.copy(0.0f, 0.0f));
                continue;
            }
            Cell c = (Cell)o;
            result.impositionObjects.add(c.copy(0.0f, 0.0f, replaceN, replaceS, docOffset));
        }
        return result;
    }

    public ImpositionTemplate place(float width, float height, AffineTransform transform) {
        ImpositionTemplate result = new ImpositionTemplate();
        result.width = width;
        result.height = height;
        result.repeatCount = this.repeatCount;
        result.documentsPerGroup = this.documentsPerGroup;
        result.pagesPerSheet = this.pagesPerSheet;
        result.nrOfCells = this.nrOfCells;
        for (ImpositionObject o : this.impositionObjects) {
            result.impositionObjects.add(o.copy(transform));
        }
        return result;
    }

    public ImpositionTemplate merge(ImpositionTemplate m) {
        ImpositionTemplate result = new ImpositionTemplate();
        result.width = this.width > m.width ? this.width : m.width;
        result.height = this.height > m.height ? this.height : m.height;
        result.repeatCount = this.repeatCount > m.repeatCount ? this.repeatCount : m.repeatCount;
        result.documentsPerGroup = this.documentsPerGroup > m.documentsPerGroup ? this.documentsPerGroup : m.documentsPerGroup;
        result.pagesPerSheet = this.pagesPerSheet > m.pagesPerSheet ? this.pagesPerSheet : m.pagesPerSheet;
        result.nrOfCells = this.nrOfCells > m.nrOfCells ? this.nrOfCells : m.nrOfCells;
        for (ImpositionObject o : this.impositionObjects) {
            result.impositionObjects.add(o.copy());
        }
        for (ImpositionObject o : m.impositionObjects) {
            result.impositionObjects.add(o.copy());
        }
        return result;
    }

    public void addCell(Cell c) {
        this.impositionObjects.add(c);
        ++this.nrOfCells;
    }

    public void addMark(SheetMark o) {
        this.impositionObjects.add(o);
    }

    public int getNrOfObjects() {
        return this.impositionObjects.size();
    }

    public ImpositionObject getObject(int i) {
        return (ImpositionObject)this.impositionObjects.get(i);
    }

    public void generate(PDFOutput stream, Parser parser, int setNr) throws IOException {
        if (this.gangDocuments) {
            this.generateGangedSet(stream, parser, setNr);
        } else {
            this.generateSet(stream, parser, setNr);
        }
    }

    private void generateSet(PDFOutput stream, Parser parser, int setNr) throws IOException {
        int setCopy = 1;
        while (setCopy <= this.setCopies) {
            int nrOfDocs = parser.getDocCount(setNr);
            int docNr = 1;
            while (docNr <= nrOfDocs) {
                int r = 1;
                while (r <= this.repeatCount) {
                    this.generate(stream, parser, setNr, docNr, r, this.docCopies, this.sheetCopies);
                    ++r;
                }
                docNr += this.documentsPerGroup;
            }
            ++setCopy;
        }
    }

    private void generateGangedSet(PDFOutput stream, Parser parser, int s) throws IOException {
        int nrOfDocs = parser.getDocCount(s);
        int[] pageIndex = new int[nrOfDocs + 1];
        int maxPages = 0;
        int docNr = 0;
        while (docNr < nrOfDocs) {
            pageIndex[docNr] = maxPages;
            int nrOfPages = parser.getPageCount(s, docNr);
            maxPages += nrOfPages;
            ++docNr;
        }
        pageIndex[nrOfDocs] = maxPages;
        int[] docNrs = new int[this.nrOfCells];
        int[] pageCounts = new int[this.nrOfCells];
        int cellNr = 0;
        for (ImpositionObject o : this.impositionObjects) {
            if (!(o instanceof Cell)) continue;
            Cell c = (Cell)o;
            int docNr2 = c.getDocNr(1, 1);
            if (docNr2 == 1) {
                docNrs[cellNr] = docNr2;
                pageCounts[cellNr++] = maxPages;
                continue;
            }
            pageCounts[cellNr++] = 0;
            docNrs[cellNr++] = -1;
        }
        int nrOfSheets = (maxPages + this.pagesPerSheet - 1) / this.pagesPerSheet;
        int docCopy = 1;
        while (docCopy <= this.docCopies * this.setCopies) {
            int sheetNr = 1;
            while (sheetNr <= nrOfSheets) {
                int sheetCopy = 1;
                while (sheetCopy <= this.sheetCopies) {
                    SheetMark m;
                    Cell c;
                    int pageNr;
                    stream.startPage(this.width, this.height);
                    cellNr = 0;
                    for (ImpositionObject o : this.impositionObjects) {
                        if (o instanceof Cell) {
                            if (o.onUpFace() && (pageNr = (c = (Cell)o).getPageNr(sheetNr, maxPages)) >= 1 && pageNr <= maxPages && docNrs[cellNr] == 1) {
                                c.displayPage(stream, parser, this.lookupPage(parser, s, pageIndex, pageNr));
                            }
                            ++cellNr;
                            continue;
                        }
                        if (!o.onUpFace()) continue;
                        m = (SheetMark)o;
                        m.display(stream, parser);
                    }
                    stream.startPage(this.width, this.height);
                    cellNr = 0;
                    for (ImpositionObject o : this.impositionObjects) {
                        if (o instanceof Cell) {
                            if (!o.onUpFace() && (pageNr = (c = (Cell)o).getPageNr(sheetNr, maxPages)) >= 1 && pageNr <= maxPages && docNrs[cellNr] == 1) {
                                c.displayPage(stream, parser, this.lookupPage(parser, s, pageIndex, pageNr));
                            }
                            ++cellNr;
                            continue;
                        }
                        if (o.onUpFace()) continue;
                        m = (SheetMark)o;
                        m.display(stream, parser);
                    }
                    ++sheetCopy;
                }
                ++sheetNr;
            }
            ++docCopy;
        }
    }

    private Scope lookupPage(Parser parser, int s, int[] pageIndex, int pageNr) {
        int ub = pageIndex.length - 1;
        int lb = 0;
        while (ub > lb + 1) {
            int index = (ub + lb) / 2;
            if (pageIndex[index] < pageNr) {
                lb = index;
                continue;
            }
            ub = index;
        }
        if (pageIndex[ub] >= pageNr) {
            return parser.getPage(s, ub, pageNr - pageIndex[ub]);
        }
        return parser.getPage(s, lb, pageNr - pageIndex[lb]);
    }

    private void generate(PDFOutput stream, Parser parser, int s, int d, int r, int docCopies, int sheetCopies) throws IOException {
        int maxPages = 0;
        int[] docNrs = new int[this.nrOfCells];
        int[] pageCounts = new int[this.nrOfCells];
        int cellNr = 0;
        for (ImpositionObject o : this.impositionObjects) {
            if (!(o instanceof Cell)) continue;
            Cell c = (Cell)o;
            int docNr = c.getDocNr(d % this.documentsPerGroup, r % this.repeatCount);
            if (docNr >= 1 && docNr <= this.documentsPerGroup) {
                int pageCount = parser.getPageCount(s, d);
                if (pageCount > maxPages) {
                    maxPages = pageCount;
                }
                docNrs[cellNr] = d + docNr;
                pageCounts[cellNr++] = pageCount;
                continue;
            }
            pageCounts[cellNr++] = 0;
            docNrs[cellNr++] = -1;
        }
        int nrOfSheets = (maxPages + this.pagesPerSheet - 1) / this.pagesPerSheet;
        int docCopy = 1;
        while (docCopy <= docCopies) {
            int sheetNr = 1;
            while (sheetNr <= nrOfSheets) {
                int sheetCopy = 1;
                while (sheetCopy <= sheetCopies) {
                    SheetMark m;
                    Cell c;
                    int pageNr;
                    stream.startPage(this.width, this.height);
                    cellNr = 0;
                    for (ImpositionObject o : this.impositionObjects) {
                        if (o instanceof Cell) {
                            if (o.onUpFace() && (pageNr = (c = (Cell)o).getPageNr(sheetNr, pageCounts[cellNr])) >= 1 && pageNr <= pageCounts[cellNr] && docNrs[cellNr] > 0) {
                                c.displayPage(stream, parser, parser.getPage(s, docNrs[cellNr], pageNr));
                            }
                            ++cellNr;
                            continue;
                        }
                        if (!o.onUpFace()) continue;
                        m = (SheetMark)o;
                        m.display(stream, parser);
                    }
                    stream.startPage(this.width, this.height);
                    cellNr = 0;
                    for (ImpositionObject o : this.impositionObjects) {
                        if (o instanceof Cell) {
                            if (!o.onUpFace() && (pageNr = (c = (Cell)o).getPageNr(sheetNr, pageCounts[cellNr])) >= 1 && pageNr <= pageCounts[cellNr] && docNrs[cellNr] > 0) {
                                c.displayPage(stream, parser, parser.getPage(s, docNrs[cellNr], pageNr));
                            }
                            ++cellNr;
                            continue;
                        }
                        if (o.onUpFace()) continue;
                        m = (SheetMark)o;
                        m.display(stream, parser);
                    }
                    ++sheetCopy;
                }
                ++sheetNr;
            }
            ++docCopy;
        }
    }
}

