/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Checksum
extends OutputStream {
    OutputStream output;
    MessageDigest md5;
    String checksum;
    static final String hexdigits = "0123456789ABCDEF";

    public MD5Checksum(OutputStream dst) throws NoSuchAlgorithmException {
        this.output = dst;
        this.md5 = MessageDigest.getInstance("MD5");
        this.checksum = null;
    }

    public String get() {
        return this.checksum;
    }

    public void close() throws IOException {
        if (this.output != null) {
            this.output.flush();
        }
        byte[] digest = this.md5.digest();
        int i = 0;
        while (i < digest.length) {
            int value = digest[i] < 0 ? 256 + digest[i] : digest[i];
            char c1 = hexdigits.charAt(value / 16);
            char c2 = hexdigits.charAt(value % 16);
            this.checksum = i > 0 ? String.valueOf(this.checksum) + c1 + c2 : "" + c1 + c2;
            ++i;
        }
        this.output = null;
    }

    public void flush() throws IOException {
        if (this.output != null) {
            this.output.flush();
        }
    }

    public void write(int b) throws IOException {
        if (b > 127) {
            this.md5.update((byte)(b - 256));
        } else {
            this.md5.update((byte)b);
        }
        if (this.output != null) {
            this.output.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        this.md5.update(b);
        if (this.output != null) {
            this.output.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.md5.update(b, off, len);
        if (this.output != null) {
            this.output.write(b, off, len);
        }
    }

    public void write(byte b) throws IOException {
        this.md5.update(b);
        if (this.output != null) {
            this.output.write(b);
        }
    }

    public void copy(InputStream input) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[512];
        while ((bytesRead = input.read(buffer)) >= 0) {
            this.write(buffer, 0, bytesRead);
        }
    }
}

