/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5ChecksumInput
extends InputStream {
    InputStream input;
    MessageDigest md5;
    String checksum;
    static final String hexdigits = "0123456789ABCDEF";

    public MD5ChecksumInput(InputStream src) throws NoSuchAlgorithmException {
        this.input = src;
        this.md5 = MessageDigest.getInstance("MD5");
        this.checksum = null;
    }

    public String get() {
        return this.checksum;
    }

    public void close() {
        byte[] digest = this.md5.digest();
        int i = 0;
        while (i < digest.length) {
            int value = digest[i] < 0 ? 256 + digest[i] : digest[i];
            char c1 = hexdigits.charAt(value / 16);
            char c2 = hexdigits.charAt(value % 16);
            this.checksum = i > 0 ? String.valueOf(this.checksum) + c1 + c2 : "" + c1 + c2;
            ++i;
        }
    }

    public int read() throws IOException {
        int b = this.input.read();
        if (b > 127) {
            this.md5.update((byte)(b - 256));
        } else {
            this.md5.update((byte)b);
        }
        return b;
    }

    public int read(byte[] b) throws IOException {
        int bytes = this.input.read(b);
        this.md5.update(b);
        return bytes;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytes = this.input.read(b, off, len);
        if (bytes > 0) {
            this.md5.update(b, off, bytes);
        }
        return bytes;
    }
}

