/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.caslon.checkPPML.File;
import net.caslon.checkPPML.MD5Checksum;
import net.caslon.checkPPML.MD5ChecksumInput;
import net.caslon.checkPPML.PDFContent;
import net.caslon.checkPPML.PDFOutput;
import net.caslon.checkPPML.Parser;
import net.caslon.checkPPML.VDXInput;
import net.caslon.checkPPML.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class ManifestGenerator
implements EntityResolver {
    public static Vector tempFiles = new Vector();
    public static boolean debugMode = false;
    public static boolean skipMode = false;
    public static boolean checkEPS = false;
    public static boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    public static boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    public static final boolean isPro = true;
    public static final boolean supportsPPML3 = true;
    public static final String version = "3.1 beta1";
    public static final boolean isDeveloper = false;
    public static boolean fixProlog = false;
    XMLWriter manifestFile;
    XMLWriter PPMLOutputStream;
    String[] features;
    String description;
    String outputFile;
    String pdfFileName;
    String imposedPdfFileName;
    String ppmlOutputFile;
    String title;
    File pdfFile;
    Parser parser;
    public boolean isVDX;
    static final String[] schemasVDX = new String[]{"http://www.podi.org/ppml/ppmlvdx.xsd", "http://www.podi.org/ppml/ppml210.xsd", "http://www.podi.org/ppml/ppml150.xsd", "http://www.podi.org/ppml/ppml102.xsd", "http://www.w3.org/2000/svg10.xsd", "http://www.w3.org/2000/xlink.xsd", "http://www.w3.org/2000/xml.xsd"};
    static final String[] schemas2 = new String[]{"http://www.podi.org/ppml/ppml220.xsd", "http://www.podi.org/ppml/ppml210.xsd", "http://www.podi.org/ppml/ppml150.xsd", "http://www.podi.org/ppml/ppml102.xsd", "http://www.w3.org/2000/svg10.xsd", "http://www.w3.org/2000/xlink.xsd", "http://www.w3.org/2000/xml.xsd"};
    static final String[] schemas3 = new String[]{"http://www.podi.org/ppml/ppml300.xsd", "http://www.podi.org/ppml/ppml220.xsd", "http://www.podi.org/ppml/ppml210.xsd", "http://www.podi.org/ppml/ppml150.xsd", "http://www.podi.org/ppml/ppml102.xsd", "http://www.w3.org/2000/svg10.xsd", "http://www.w3.org/2000/xlink.xsd", "http://www.w3.org/2000/xml.xsd"};
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public static void deleteWhenDone(java.io.File file) {
        if (!debugMode) {
            file.deleteOnExit();
            tempFiles.add(file);
        }
    }

    public static String getLocation(Throwable e) {
        StackTraceElement[] trace;
        if (e.getCause() != null) {
            e = e.getCause();
        }
        if ((trace = e.getStackTrace()).length > 0) {
            return " (" + trace[0].getFileName() + ":" + trace[0].getLineNumber() + ")";
        }
        return "";
    }

    public static String getInstallationPath() {
        return new java.io.File(ClassLoader.getSystemResource("manifest.jar").getPath().replaceAll("%20", " ")).getParentFile().getAbsolutePath();
    }

    public static String getVersion() {
        return "Professional 3.1 beta1";
    }

    public static void main(String[] args) {
        Vector<String> features = new Vector<String>();
        Vector<String> preload = new Vector<String>();
        String outputFile = null;
        String ppmlFile = null;
        String ppmlOutputFile = null;
        String description = null;
        String pdfFile = null;
        String imposedPdfFile = null;
        String fileDir = null;
        String title = null;
        String logfilename = null;
        int fromPage = 1;
        int toPage = -1;
        Logger logger = Logger.getLogger("ManifestGenerator");
        System.setProperty("java.awt.headless", "true");
        if (isMac) {
            System.setProperty("com.sun.media.imageio.disableCodecLib", "true");
        }
        if (isMac) {
            PDFContent.useBuiltin();
        } else {
            PDFContent.useGhostScript();
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-f")) {
                features.add(args[i + 1]);
                features.add(args[i + 2]);
                i += 2;
            } else if (args[i].equals("-s")) {
                fileDir = args[i + 1];
                ++i;
            } else if (args[i].equals("-o")) {
                outputFile = args[i + 1];
                ++i;
            } else if (args[i].equals("-pdf")) {
                pdfFile = args[i + 1];
                ++i;
            } else {
                args[i].equals("-imposedpdf");
                if (args[i].equals("-d")) {
                    description = args[i + 1];
                    ++i;
                } else if (args[i].equals("-debug")) {
                    debugMode = true;
                } else if (args[i].equals("-skip")) {
                    skipMode = true;
                } else if (args[i].equals("-distiller")) {
                    PDFContent.useDistiller();
                } else if (args[i].equals("-gs")) {
                    PDFContent.useGhostScript();
                } else if (args[i].equals("-checkEPS")) {
                    checkEPS = true;
                } else if (args[i].equals("-from")) {
                    fromPage = Integer.parseInt(args[i + 1]);
                    ++i;
                } else if (args[i].equals("-to")) {
                    toPage = Integer.parseInt(args[i + 1]);
                    ++i;
                } else if (args[i].equals("-t")) {
                    title = args[i + 1];
                    ++i;
                } else if (args[i].equals("-log")) {
                    logfilename = args[i + 1];
                    ++i;
                } else if (args[i].equals("-fixprolog")) {
                    fixProlog = true;
                } else if (i == args.length - 1) {
                    ppmlFile = args[i];
                } else {
                    preload.add(args[i]);
                }
            }
            ++i;
        }
        if (ppmlFile == null || pdfFile == null) {
            String msg = "CheckPPML - " + ManifestGenerator.getVersion() + "\n";
            msg = String.valueOf(msg) + "Usage: [-o <outputFile>] [-pdf <pdfFile>] [-distiller|-gs] [-fixprolog]";
            msg = String.valueOf(msg) + "[-s <file dir>] [-d <description>] [-t <title>] [-f <featurename> <categoryname>]* [-log <logfile>] [<preloadfile>]+ <ppmlFile>";
            logger.log(Level.INFO, msg);
            logger.log(Level.INFO, "Installation directory = " + ManifestGenerator.getInstallationPath());
            return;
        }
        Handler handler = null;
        OutputStream logFile = null;
        ByteArrayOutputStream output = null;
        if (logfilename != null) {
            logger = Logger.getLogger("ManifestGenerator");
            logger.setUseParentHandlers(false);
            Logger parserLogger = Logger.getLogger("Parser");
            parserLogger.setParent(logger);
            output = new ByteArrayOutputStream();
            System.setErr(new PrintStream(output));
            System.setOut(new PrintStream(output));
            Handler[] handlers = logger.getHandlers();
            int i2 = 0;
            while (i2 < handlers.length) {
                logger.removeHandler(handlers[i2]);
                ++i2;
            }
            try {
                logFile = new FileOutputStream(logfilename);
                handler = new StreamHandler(logFile, new SimpleFormatter());
                logger.addHandler(handler);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Cannot create log file '" + logfilename + "'");
                System.exit(1);
            }
        }
        try {
            ManifestGenerator generator = new ManifestGenerator(features.toArray(new String[0]), title, description, outputFile, pdfFile, imposedPdfFile, ppmlOutputFile, fileDir);
            int i3 = 0;
            while (i3 < preload.size()) {
                generator.generate((String)preload.get(i3), false, 1, -1);
                ++i3;
            }
            generator.generate(ppmlFile, true, fromPage, toPage);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.toString());
        }
        Enumeration elements = tempFiles.elements();
        while (elements.hasMoreElements()) {
            java.io.File file = (java.io.File)elements.nextElement();
            if (file.delete()) continue;
            file.deleteOnExit();
        }
        tempFiles.clear();
        try {
            if (handler != null) {
                handler.flush();
            }
            if (logFile != null) {
                logFile.flush();
            }
            if (output != null && output.size() > 0) {
                ((FileOutputStream)logFile).write(output.toByteArray());
                logFile.flush();
            }
            if (logFile != null) {
                ((FileOutputStream)logFile).close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ManifestGenerator(String[] features, String title, String description, String outputFile, String pdfFile, String imposedPdfFile, String ppmlOutputFile, String fileDir) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        this.features = features;
        this.description = description;
        this.outputFile = outputFile;
        this.ppmlOutputFile = ppmlOutputFile;
        this.pdfFileName = pdfFile;
        this.imposedPdfFileName = imposedPdfFile;
        this.title = title;
        this.parser = new Parser();
        if (fileDir != null) {
            this.parser.setFileDir(fileDir);
        } else if (debugMode) {
            this.parser.setFileDir(".");
        } else {
            this.parser.setFileDir(System.getProperty("java.io.tmpdir"));
        }
        if (outputFile != null) {
            try {
                this.manifestFile = new XMLWriter(new PrintWriter(new FileOutputStream(outputFile)));
            }
            catch (Exception e) {
                throw new IOException("Error while creating " + outputFile + ": " + e.getMessage());
            }
        }
        if (ppmlOutputFile != null) {
            try {
                this.PPMLOutputStream = new XMLWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ppmlOutputFile), "utf-8")));
            }
            catch (Exception e) {
                throw new IOException("Error while creating " + ppmlOutputFile + ": " + e.getMessage());
            }
        }
    }

    void generate(String filename, boolean output, int fromPage, int toPage) throws IOException {
        MD5ChecksumInput md5checksum;
        InputStream inputStream;
        URL input;
        boolean isZip = false;
        try {
            input = filename.indexOf(58) == 1 ? new java.io.File(filename).toURL() : new URL(new URL("file:."), filename);
            if (filename.endsWith(".zip")) {
                ZipFile zip = new ZipFile(input.getFile());
                Enumeration<? extends ZipEntry> files = zip.entries();
                while (files.hasMoreElements()) {
                    ZipEntry entry = files.nextElement();
                    String name = entry.getName();
                    if (!name.toLowerCase().endsWith(".ppml") || name.contains("/") || name.contains("\\") || name.contains(System.getProperty("path.separator"))) continue;
                    input = new URL("jar:" + input + "!/" + name);
                    isZip = true;
                }
                inputStream = input.openStream();
            } else if (filename.endsWith(".vdx")) {
                VDXInput vdxInput = new VDXInput(filename);
                inputStream = vdxInput.getPPMLStream();
                this.isVDX = true;
            } else {
                inputStream = input.openStream();
            }
        }
        catch (MalformedURLException e) {
            throw new IOException("Can't open file " + filename + ": " + e.getMessage());
        }
        this.parser.setBase(input, isZip);
        try {
            md5checksum = new MD5ChecksumInput(inputStream);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Can't load the MD5 calculation class: " + e.getMessage());
        }
        if (output) {
            PDFOutput pdf = new PDFOutput(this.title, this.pdfFileName);
            this.parser.setOutput(pdf, fromPage, toPage);
            if (this.imposedPdfFileName != null) {
                PDFOutput imposedPdf = new PDFOutput(String.valueOf(this.title) + " (imposed)", this.imposedPdfFileName);
                this.parser.setImposedOutput(imposedPdf);
            }
        }
        if (output && this.PPMLOutputStream != null) {
            this.parser.setPPMLOutput(this.PPMLOutputStream);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        try {
            SAXParser xmlparser = factory.newSAXParser();
            xmlparser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            xmlparser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.isVDX ? schemasVDX : schemas3);
            XMLReader reader = xmlparser.getXMLReader();
            InputSource src = new InputSource(md5checksum);
            reader.setContentHandler(this.parser);
            reader.setErrorHandler(this.parser);
            reader.setEntityResolver(this);
            reader.parse(src);
        }
        catch (Exception e) {
            if (inputStream != null) {
                inputStream.close();
            }
            try {
                this.parser.endDocument();
            }
            catch (Exception reader) {
                // empty catch block
            }
            if (debugMode) {
                e.printStackTrace(System.err);
            }
            throw new IOException("Error occurred while parsing " + filename + ": " + e + ManifestGenerator.getLocation(e));
        }
        if (inputStream != null) {
            inputStream.close();
        }
        if (output && this.PPMLOutputStream != null) {
            this.PPMLOutputStream.close();
        }
        if (output && this.manifestFile != null) {
            String checksum = md5checksum.get();
            File ppmlFile = new File("PPMLFILE", "application/vnd.podi-ppml+xml", filename, checksum);
            try {
                MD5Checksum pdfChecksum = new MD5Checksum(null);
                pdfChecksum.copy(new FileInputStream(this.pdfFileName));
                pdfChecksum.close();
                this.pdfFile = new File("OUTPUTFILE", "application/pdf", this.pdfFileName, pdfChecksum.get());
            }
            catch (Exception e) {
                throw new IOException("Error while reading " + this.pdfFileName + ": " + e.getMessage());
            }
            this.manifestFile.startElement("MANIFEST");
            this.manifestFile.writeAttribute("Version", ManifestGenerator.getVersion());
            this.manifestFile.startElement("FEATURES");
            int featureCount = this.features.length / 2;
            int i = 0;
            while (i < featureCount) {
                this.manifestFile.startElement("FEATURE");
                this.manifestFile.writeAttribute("Category", this.features[2 * i]);
                this.manifestFile.writeAttribute("Name", this.features[2 * i + 1]);
                this.manifestFile.endElement("FEATURE");
                ++i;
            }
            this.manifestFile.endElement("FEATURES");
            this.manifestFile.startElement("DESCRIPTION");
            this.manifestFile.writeText(this.description);
            this.manifestFile.endElement("DESCRIPTION");
            ppmlFile.write(this.manifestFile);
            this.pdfFile.write(this.manifestFile);
            this.manifestFile.startElement("CONTENTFILES");
            Iterator it = this.parser.getContentFiles();
            while (it.hasNext()) {
                File file = (File)it.next();
                file.write(this.manifestFile);
            }
            this.manifestFile.endElement("CONTENTFILES");
            this.parser.write(this.manifestFile);
            this.manifestFile.endElement("MANIFEST");
            this.manifestFile.close();
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        Logger logger = Logger.getLogger("ManifestGenerator");
        if (publicId != null && publicId.equals("-//PODi//DTD PPML 1.02//EN")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml102.dtd"));
        }
        if (publicId != null && publicId.equals("-//PODi//DTD PPML 1.5//EN")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml1.5.0.dtd"));
        }
        if (publicId != null && publicId.equals("-//PODi//DTD PPML 2.0//EN")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml210.dtd"));
        }
        if (publicId != null && publicId.equals("-//PODi//DTD PPML 2.1//EN")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml210.dtd"));
        }
        if (publicId != null && publicId.equals("-//PODi//DTD PPML 2.2//EN")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml220.dtd"));
        }
        if (publicId != null && publicId.equals("-//PODi//DTD PPML 2.10//EN")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml210.dtd"));
        }
        if (publicId != null && publicId.equals("-//PODi//DTD PPML 2.20//EN")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml220.dtd"));
        }
        if (publicId != null && publicId.equals("-//PODi//DTD PPML 3.00//EN")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml300.dtd"));
        }
        if (systemId != null && systemId.equals("http://www.podi.org/ppml/ppml150.xsd")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml150.xsd"));
        }
        if (systemId != null && systemId.equals("http://www.podi.org/ppml/ppml102.xsd")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml102.xsd"));
        }
        if (systemId != null && systemId.equals("http://www.podi.org/ppml/ppml200.xsd")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml210.xsd"));
        }
        if (systemId != null && systemId.equals("http://www.podi.org/ppml/ppml220.xsd")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml220.xsd"));
        }
        if (systemId != null && systemId.equals("http://www.podi.org/ppml/ppml210.xsd")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml210.xsd"));
        }
        if (systemId != null && systemId.equals("http://www.podi.org/ppml/ppml300.xsd")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml300.xsd"));
        }
        if (systemId != null && systemId.equals("http://www.w3.org/2000/svg10.xsd")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/svg10.xsd"));
        }
        if (systemId != null && systemId.equals("http://www.w3.org/2000/xlink.xsd")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/xlink.xsd"));
        }
        if (systemId != null && systemId.equals("http://www.w3.org/2000/xml.xsd")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/xml.xsd"));
        }
        if (systemId != null && systemId.equals("http://www.podi.org/ppml/jdf-1.1.xsd")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/jdf-1.1.xsd"));
        }
        if (systemId != null && systemId.equals("http://www.podi.org/ppml/ppmlvdx.xsd")) {
            return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppmlvdx.xsd"));
        }
        logger.log(Level.WARNING, "No PPML 1.5, 2.1 or 2.2 DOCTYPE or Schema definition found, defaulting to PPML 2.2");
        return new InputSource(ClassLoader.getSystemResourceAsStream("dtd/ppml220.dtd"));
    }

    public static class VDXNameSpaceFilter
    extends XMLFilterImpl {
        private static final String NAMESPACE = "http://www.podi.org/ppml/ppmlvdx.xsd";

        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(NAMESPACE, localName, qName);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(NAMESPACE, localName, qName, atts);
        }
    }
}

