/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import net.caslon.checkPPML.File;
import net.caslon.checkPPML.PositionedView;
import net.caslon.checkPPML.Resource;
import net.caslon.checkPPML.XMLSerialisable;
import net.caslon.checkPPML.XMLWriter;

public class Object
implements XMLSerialisable {
    Vector files;
    Vector resources;
    String elementName;
    protected String name;
    protected String environment;
    String format;
    double width;
    double height;
    double x;
    double y;
    Area clip;
    AffineTransform transform;
    String checksum;
    int index;
    String fileName;
    String location;
    int psIndex;
    String blendMode;
    String transparency;
    boolean isolated;
    boolean knockout;
    double opacity;
    String blendColorSpace;
    Vector objects;
    Object parent;
    Object softmask;

    public Object(String sourceLocation, String format, int index, double width, double height, Area clip, AffineTransform transform, String checksum, String fileName, String blendMode, String transparency) {
        this.elementName = "OBJECT";
        this.location = sourceLocation;
        this.name = null;
        this.environment = null;
        this.files = new Vector();
        this.resources = new Vector();
        this.psIndex = -1;
        this.format = format;
        this.index = index;
        this.width = width;
        this.height = height;
        this.clip = clip;
        this.transform = transform;
        this.checksum = checksum;
        this.fileName = fileName;
        this.blendMode = blendMode;
        this.blendColorSpace = null;
        this.transparency = transparency;
        this.isolated = true;
        this.knockout = true;
        this.objects = new Vector();
        this.parent = null;
        this.softmask = null;
        this.opacity = -1.0;
        this.x = 0.0;
        this.y = 0.0;
    }

    public Object(String sourceLocation, Object parent, String blendMode, String blendColorSpace, boolean knockout, boolean isolated) {
        this.elementName = "GROUP";
        this.location = sourceLocation;
        this.name = null;
        this.environment = null;
        this.files = new Vector();
        this.resources = new Vector();
        this.psIndex = -1;
        this.format = null;
        this.index = -1;
        this.width = 0.0;
        this.height = 0.0;
        this.clip = new Area();
        this.transform = new AffineTransform();
        this.checksum = this.checksum;
        this.fileName = this.fileName;
        this.transparency = null;
        this.blendMode = blendMode;
        this.blendColorSpace = blendColorSpace;
        this.isolated = isolated;
        this.knockout = knockout;
        this.objects = new Vector();
        this.parent = parent;
        this.softmask = null;
        this.opacity = -1.0;
        this.x = 0.0;
        this.y = 0.0;
    }

    public Object(String sourceLocation, double opacity) {
        this.elementName = "SOFTMASK";
        this.location = sourceLocation;
        this.name = null;
        this.environment = null;
        this.files = new Vector();
        this.resources = new Vector();
        this.psIndex = -1;
        this.format = null;
        this.index = -1;
        this.width = 0.0;
        this.height = 0.0;
        this.clip = new Area();
        this.transform = new AffineTransform();
        this.checksum = null;
        this.fileName = null;
        this.transparency = null;
        this.blendMode = null;
        this.blendColorSpace = null;
        this.isolated = false;
        this.knockout = false;
        this.objects = new Vector();
        this.parent = null;
        this.softmask = null;
        this.opacity = opacity;
        this.x = 0.0;
        this.y = 0.0;
    }

    public void setView(PositionedView view) {
        AffineTransform viewTransform = view.getTransform();
        AffineTransform transform = new AffineTransform();
        AffineTransform viewTranslate = AffineTransform.getTranslateInstance(this.x, this.y);
        if (viewTransform != null) {
            transform.preConcatenate(viewTransform);
        }
        this.clip.transform(transform);
        this.transform.preConcatenate(viewTranslate);
        this.transform.preConcatenate(transform);
        Rectangle clipRect = view.getClipRect();
        if (clipRect != null) {
            this.clip.intersect(new Area(clipRect));
        }
        this.clip.transform(viewTranslate);
        this.x = view.getX();
        this.y = view.getY();
        this.width = this.clip.getBounds().getWidth();
        this.height = this.clip.getBounds().getHeight();
    }

    public void addObject(Object ref) {
        Area objClip = ref.getClipPath();
        this.clip.add(objClip.createTransformedArea(AffineTransform.getTranslateInstance(ref.getX(), ref.getY())));
        this.width = this.clip.getBounds().getWidth();
        this.height = this.clip.getBounds().getHeight();
        this.objects.add(ref);
        ref.parent = this;
    }

    public void setSoftMask(Object mask) {
        this.softmask = mask;
    }

    public Object(PositionedView view, Object ref) {
        this(view, ref, ref.blendMode);
    }

    public Object(PositionedView view, Object ref, String blendMode) {
        this.elementName = ref.elementName;
        this.location = ref.location;
        this.name = ref.name;
        this.environment = this.environment;
        this.format = ref.format;
        this.index = ref.index;
        this.psIndex = ref.psIndex;
        this.width = ref.width;
        this.height = ref.height;
        this.checksum = ref.checksum;
        this.files = ref.files;
        this.resources = ref.resources;
        this.fileName = ref.fileName;
        this.transparency = ref.transparency;
        this.blendMode = blendMode;
        this.blendColorSpace = ref.blendColorSpace;
        this.isolated = ref.isolated;
        this.knockout = ref.knockout;
        this.objects = ref.objects;
        this.clip = new Area(ref.clip);
        this.parent = ref.parent;
        this.softmask = ref.softmask;
        this.transform = new AffineTransform(ref.transform);
        this.x = view.getX();
        this.y = view.getY();
        AffineTransform viewTransform = view.getTransform();
        AffineTransform transform = new AffineTransform();
        AffineTransform viewTranslate = AffineTransform.getTranslateInstance(ref.x, ref.y);
        if (viewTransform != null) {
            transform.preConcatenate(viewTransform);
        }
        this.clip.transform(transform);
        this.transform.preConcatenate(viewTranslate);
        this.transform.preConcatenate(transform);
        Rectangle clipRect = view.getClipRect();
        if (clipRect != null) {
            this.clip.intersect(new Area(clipRect));
        }
        this.clip.transform(viewTranslate);
    }

    public Object(String name, String environment, Object ref) {
        this.elementName = ref.isGroup() ? "GROUP_REF" : "OBJECT_REF";
        this.name = name;
        this.location = ref.location;
        this.environment = environment;
        this.format = ref.format;
        this.index = ref.index;
        this.psIndex = ref.psIndex;
        this.width = ref.width;
        this.height = ref.height;
        this.fileName = ref.fileName;
        this.clip = new Area(ref.clip);
        this.transform = new AffineTransform(ref.transform);
        this.checksum = ref.checksum;
        this.files = ref.files;
        this.resources = ref.resources;
        this.blendMode = ref.blendMode;
        this.transparency = ref.transparency;
        this.blendColorSpace = ref.blendColorSpace;
        this.isolated = ref.isolated;
        this.knockout = ref.knockout;
        this.objects = ref.objects;
        this.parent = ref.parent;
        this.softmask = ref.softmask;
        this.x = ref.x;
        this.y = ref.y;
    }

    public void addDependency(File file) {
        this.files.add(file);
    }

    public void addDependency(Resource resource) {
        this.resources.add(resource);
    }

    public Iterator getResourceDependencies() {
        return this.resources.iterator();
    }

    public void write(XMLWriter stream) throws IOException {
        stream.startElement(this.elementName);
        if (this.name != null) {
            stream.writeAttribute("Name", this.name);
        }
        if (this.environment != null) {
            stream.writeAttribute("Environment", this.environment);
        }
        if (this.format != null) {
            stream.writeAttribute("Format", this.format);
        }
        stream.writeAttribute("Dimensions", String.valueOf(this.width) + " " + this.height);
        stream.writeAttribute("Position", String.valueOf(this.x) + " " + this.y);
        if (this.index > 1) {
            stream.writeAttribute("Index", Integer.toString(this.index));
        }
        stream.writeAttribute("Clip", Object.getPoints(this.clip));
        stream.writeAttribute("Transform", Object.getMatrix(this.transform));
        if (this.checksum != null) {
            stream.writeAttribute("Checksum", this.checksum);
        }
        if (this.blendMode != null) {
            stream.writeAttribute("BlendMode", this.blendMode);
        }
        if (this.blendColorSpace != null) {
            stream.writeAttribute("BlendColorSpace", this.blendColorSpace);
        }
        if (this.format == null) {
            stream.writeAttribute("Isolated", Boolean.toString(this.isolated));
            stream.writeAttribute("Knockout", Boolean.toString(this.knockout));
        }
        if (this.transparency != null) {
            stream.writeAttribute("Transparency", this.transparency);
        }
        Rectangle bbox = this.clip.getBounds();
        stream.writeAttribute("bbox", String.valueOf(bbox.getMinX()) + " " + bbox.getMinY() + " " + bbox.getMaxX() + " " + bbox.getMaxY());
        if (this.softmask != null) {
            stream.startElement("SOFTMASK");
            if (this.softmask.opacity != 1.0) {
                stream.writeAttribute("Opacity", Double.toString(this.softmask.opacity));
            } else {
                this.softmask.write(stream);
            }
            stream.endElement("SOFTMASK");
        }
        int nrOfObjects = this.objects.size();
        int i = 0;
        while (i < nrOfObjects) {
            ((XMLSerialisable)this.objects.get(i)).write(stream);
            ++i;
        }
        int nrOfFiles = this.files.size();
        int i2 = 0;
        while (i2 < nrOfFiles) {
            ((XMLSerialisable)this.files.get(i2)).write(stream);
            ++i2;
        }
        int nrOfResources = this.resources.size();
        int i3 = 0;
        while (i3 < nrOfResources) {
            ((XMLSerialisable)this.resources.get(i3)).write(stream);
            ++i3;
        }
        stream.endElement(this.elementName);
    }

    public void setPSIndex(int index) {
        this.psIndex = index;
    }

    public boolean isRef() {
        return this.elementName.equals("GROUP_REF") || this.elementName.equals("OBJECT_REF");
    }

    public boolean isGroup() {
        return this.elementName.equals("GROUP") || this.elementName.equals("GROUP_REF");
    }

    public Iterator getObjects() {
        return this.objects.iterator();
    }

    public Object getSoftMask() {
        return this.softmask;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public boolean isKnockout() {
        return this.knockout;
    }

    public String getTransparency() {
        return this.transparency;
    }

    public String getBlendMode() {
        return this.blendMode;
    }

    public String getBlendColorSpace() {
        return this.blendColorSpace;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFormat() {
        return this.format;
    }

    public int getIndex() {
        return this.index;
    }

    public int getPSIndex() {
        return this.psIndex;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String getFileName() {
        return this.fileName;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public Area getClipPath() {
        return this.clip;
    }

    public com.lowagie.text.Rectangle getBBox() {
        Rectangle bbox = this.clip.getBounds();
        return new com.lowagie.text.Rectangle((float)bbox.getMinX(), (float)bbox.getMinY(), (float)bbox.getMaxX(), (float)bbox.getMaxY());
    }

    public String getEnvironment() {
        return this.environment;
    }

    public static String getMatrix(AffineTransform transform) {
        return String.valueOf(transform.getScaleX()) + " " + transform.getShearY() + " " + transform.getShearX() + " " + transform.getScaleY() + " " + transform.getTranslateX() + " " + transform.getTranslateY();
    }

    public static String getPoints(Area area) {
        String result = "";
        double[] points = new double[6];
        double startX = 0.0;
        double startY = 0.0;
        PathIterator it = area.getPathIterator(null);
        while (!it.isDone()) {
            int segmentType = it.currentSegment(points);
            if (segmentType == 0) {
                result = String.valueOf(points[0]) + " " + points[1];
                startX = points[0];
                startY = points[1];
            } else if (segmentType == 1) {
                result = String.valueOf(result) + " " + points[0] + " " + points[1];
            }
            it.next();
        }
        return result;
    }

    public boolean hasCompatibleContext(Object match) {
        if (this.psIndex >= 0) {
            return true;
        }
        int nrOfResources = this.resources.size();
        if (nrOfResources != match.resources.size()) {
            return false;
        }
        int i = 0;
        while (i < nrOfResources) {
            if (this.resources.get(i) != match.resources.get(i)) {
                return false;
            }
            ++i;
        }
        if (this.fileName == null && match.fileName == null) {
            return true;
        }
        return this.fileName.equals(match.fileName);
    }

    public String cacheName() {
        if (this.isRef()) {
            return String.valueOf(this.getName()) + "-" + this.objects.hashCode();
        }
        return this.getFileName();
    }
}

