/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import net.caslon.checkPPML.ConstantExpression;
import net.caslon.checkPPML.DyadicExpression;
import net.caslon.checkPPML.NExpression;
import net.caslon.checkPPML.Offset;
import net.caslon.checkPPML.Operator;
import net.caslon.checkPPML.ReplaceNExpression;
import net.caslon.checkPPML.ReplaceSExpression;
import net.caslon.checkPPML.SExpression;

public class OrderExpression {
    public static void main(String[] args) {
        int s = Integer.parseInt(args[0]);
        int n = Integer.parseInt(args[1]);
        String expr = args[2];
        String replace = null;
        if (args.length > 3) {
            replace = args[3];
        }
        try {
            OrderExpression o = OrderExpression.parse(expr);
            if (replace != null) {
                o = o.replaceS(replace);
            }
            System.err.println("s = " + s + ", n = " + n + ", expr = " + expr + ", parse = " + o + ", result = " + o.calculate(s, n));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static OrderExpression parse(String expr) throws Exception {
        Offset offset = new Offset(0);
        OrderExpression.skipWhiteSpace(expr, offset);
        OrderExpression result = OrderExpression.parse(expr, offset, 0);
        if (offset.value() < expr.length()) {
            throw new Exception("Unexpected ) at offset " + offset.value() + " in expression \"" + expr + "\"");
        }
        return result;
    }

    public static OrderExpression parse(String expr, Offset offset, int priority) throws Exception {
        int length = expr.length();
        OrderExpression result = null;
        if (offset.value() >= length) {
            throw new Exception("Expected an operand at offset " + (offset.value() + 1) + " in expression \"" + expr + "\"");
        }
        char c = expr.charAt(offset.value());
        if (c >= '0' && c <= '9') {
            int value = c - 48;
            offset.inc();
            while (offset.value() < length) {
                c = expr.charAt(offset.value());
                if (c < '0' || c > '9') break;
                value = value * 10 + (c - 48);
                offset.inc();
            }
            result = new ConstantExpression(value);
        } else if (c == 's') {
            offset.inc();
            result = new SExpression();
        } else if (c == 'n') {
            offset.inc();
            result = new NExpression();
        } else if (c == '(') {
            offset.inc();
            result = OrderExpression.parse(expr, offset, 0);
            offset.inc();
        } else {
            throw new Exception("Expected an operand at offset " + (offset.value() + 1) + " in expression \"" + expr + "\"");
        }
        OrderExpression.skipWhiteSpace(expr, offset);
        while (offset.value() < length) {
            c = expr.charAt(offset.value());
            if (c == ')') {
                return result;
            }
            Operator op = Operator.getInstance(c);
            if (op == null) {
                throw new Exception("Expected an operator at offset " + (offset.value() + 1) + " in expression \"" + expr + "\"");
            }
            if (op.getPriority() <= priority) {
                return result;
            }
            offset.inc();
            OrderExpression.skipWhiteSpace(expr, offset);
            result = new DyadicExpression(result, op, OrderExpression.parse(expr, offset, op.getPriority()));
            OrderExpression.skipWhiteSpace(expr, offset);
        }
        return result;
    }

    private static void skipWhiteSpace(String expr, Offset offset) {
        int length = expr.length();
        while (offset.value() < length) {
            char c = expr.charAt(offset.value());
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            offset.inc();
        }
    }

    public OrderExpression replaceS(String expr) throws Exception {
        return new ReplaceSExpression(this, OrderExpression.parse(expr));
    }

    public OrderExpression replaceS(OrderExpression expr) {
        return new ReplaceSExpression(this, expr);
    }

    public OrderExpression replaceN(String expr) throws Exception {
        return new ReplaceNExpression(this, OrderExpression.parse(expr));
    }

    public OrderExpression replaceN(OrderExpression expr) {
        return new ReplaceNExpression(this, expr);
    }

    public static OrderExpression constant(int value) {
        return new ConstantExpression(value);
    }

    public OrderExpression add(OrderExpression expr) {
        return new DyadicExpression(this, Operator.ADD, expr);
    }

    public int calculate(int s, int n) {
        return 0;
    }
}

