/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Variant;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.caslon.checkPPML.Content;
import net.caslon.checkPPML.Copier;
import net.caslon.checkPPML.ManifestGenerator;
import net.caslon.checkPPML.PDFOutput;

public class PDFContent
implements Content {
    static String psConverter = "gs";
    static boolean use64BitConverter = false;
    public static String psPrefix = "";
    PdfReader reader;
    PDFOutput output;
    String fileName;
    boolean isPDF;
    int nrOfPages;
    int pageNr;
    PdfImportedPage page;
    int rotate;
    float width;
    float height;
    String blendColorSpace;
    static String path = null;
    static boolean distillerSecuritySwitch = false;
    static Logger logger = Logger.getLogger("ManifestGenerator");

    public static void useDistiller() {
        String latestVersion;
        block21: {
            psConverter = "distiller";
            psPrefix = "";
            latestVersion = "";
            if (ManifestGenerator.isWindows) {
                String name;
                int i;
                int count;
                RegistryKey key;
                try {
                    key = Registry.HKEY_CURRENT_USER.openSubKey("Software").openSubKey("Adobe").openSubKey("Acrobat Distiller");
                    latestVersion = "";
                    count = key.getNumberSubkeys();
                    i = 0;
                    while (i < count) {
                        name = key.regEnumKey(i);
                        if (name.matches("[0-9]+\\.[0-9]+") && name.compareTo(latestVersion) > 0) {
                            latestVersion = name;
                        }
                        ++i;
                    }
                    path = !latestVersion.equals("") ? key.openSubKey(latestVersion).openSubKey("InstallPath").getDefaultValue() : null;
                }
                catch (Exception e) {
                    path = null;
                }
                if (path == null) {
                    try {
                        key = Registry.HKEY_LOCAL_MACHINE.openSubKey("Software").openSubKey("Adobe").openSubKey("Acrobat Distiller");
                        latestVersion = "";
                        count = key.getNumberSubkeys();
                        i = 0;
                        while (i < count) {
                            name = key.regEnumKey(i);
                            if (name.matches("[0-9]+\\.[0-9]+") && name.compareTo(latestVersion) > 0) {
                                latestVersion = name;
                            }
                            ++i;
                        }
                        path = !latestVersion.equals("") ? key.openSubKey(latestVersion).openSubKey("InstallPath").getDefaultValue() : null;
                    }
                    catch (Exception e) {
                        path = null;
                    }
                }
                if (path == null) {
                    try {
                        key = Registry.HKEY_LOCAL_MACHINE.openSubKey("Software").openSubKey("Wow6432Node").openSubKey("Adobe").openSubKey("Acrobat Distiller");
                        count = key.getNumberSubkeys();
                        latestVersion = "";
                        i = 0;
                        while (i < count) {
                            name = key.regEnumKey(i);
                            if (name.matches("[0-9]+\\.[0-9]+") && name.compareTo(latestVersion) > 0) {
                                latestVersion = name;
                            }
                            ++i;
                        }
                        if (!latestVersion.equals("")) {
                            path = key.openSubKey(latestVersion).openSubKey("InstallPath").getDefaultValue();
                            break block21;
                        }
                        path = null;
                    }
                    catch (Exception e) {
                        path = null;
                    }
                }
            } else {
                path = null;
            }
        }
        if (path == null) {
            Logger.getLogger("Parser").log(Level.INFO, "No Acobat Distiller found");
        } else {
            try {
                int majorNr = Integer.parseInt(latestVersion.substring(0, latestVersion.indexOf(".")));
                distillerSecuritySwitch = majorNr >= 8;
            }
            catch (NumberFormatException e) {
                distillerSecuritySwitch = true;
            }
        }
    }

    public static String getPath() {
        return path;
    }

    public static void useGhostScript() {
        block19: {
            psConverter = "gs";
            psPrefix = "";
            if (ManifestGenerator.isWindows) {
                String name;
                int i;
                int count;
                String latestVersion;
                RegistryKey key;
                try {
                    key = Registry.HKEY_LOCAL_MACHINE.openSubKey("Software").openSubKey("AFPL Ghostscript");
                    latestVersion = "";
                    count = key.getNumberSubkeys();
                    i = 0;
                    while (i < count) {
                        name = key.regEnumKey(i);
                        if (name.matches("[0-9]+\\.[0-9]+") && name.compareTo(latestVersion) > 0) {
                            latestVersion = name;
                        }
                        ++i;
                    }
                    if (!latestVersion.equals("")) {
                        path = key.openSubKey(latestVersion).getStringValue("GS_DLL");
                        if (path.contains("gsdll64.dll")) {
                            use64BitConverter = false;
                            path = path.replace(String.valueOf(System.getProperty("file.separator")) + "gsdll64.dll", "");
                        } else {
                            path = path.replace(String.valueOf(System.getProperty("file.separator")) + "gsdll32.dll", "");
                        }
                    } else {
                        path = null;
                    }
                }
                catch (Exception e) {
                    path = null;
                }
                if (path == null) {
                    try {
                        key = Registry.HKEY_LOCAL_MACHINE.openSubKey("Software").openSubKey("GPL Ghostscript");
                        latestVersion = "";
                        count = key.getNumberSubkeys();
                        i = 0;
                        while (i < count) {
                            name = key.regEnumKey(i);
                            if (name.matches("[0-9]+\\.[0-9]+") && name.compareTo(latestVersion) > 0) {
                                latestVersion = name;
                            }
                            ++i;
                        }
                        if (!latestVersion.equals("")) {
                            path = key.openSubKey(latestVersion).getStringValue("GS_DLL");
                            if (path.contains("gsdll64.dll")) {
                                use64BitConverter = false;
                                path = path.replace(String.valueOf(System.getProperty("file.separator")) + "gsdll64.dll", "");
                            } else {
                                path = path.replace(String.valueOf(System.getProperty("file.separator")) + "gsdll32.dll", "");
                            }
                            break block19;
                        }
                        path = null;
                    }
                    catch (Exception e) {
                        path = null;
                    }
                }
            } else {
                path = new File("/usr/local/bin/gs").exists() ? "/usr/local/bin/" : (new File("/usr/bin/gs").exists() ? "/usr/bin/" : null);
            }
        }
        if (path == null) {
            Logger.getLogger("Parser").log(Level.INFO, "No GhostScript found");
        }
    }

    public static void useBuiltin() {
        psConverter = "builtin";
        psPrefix = ".";
        path = null;
    }

    public PDFContent(PDFOutput output, String fileName, int pageNr, String blendColorSpace) throws IOException {
        this.reader = new PdfReader(fileName);
        this.output = output;
        this.nrOfPages = this.reader.getNumberOfPages();
        this.fileName = fileName;
        this.blendColorSpace = blendColorSpace;
        this.isPDF = true;
        this.setPage(pageNr, 0.0f, 0.0f);
    }

    public PDFContent(PDFOutput output, String fileName, int pageNr, boolean isPDF, String BlendColorSpace) throws IOException {
        this.reader = new PdfReader(fileName);
        this.output = output;
        this.nrOfPages = this.reader.getNumberOfPages();
        this.fileName = fileName;
        this.isPDF = isPDF;
        this.blendColorSpace = this.blendColorSpace;
        this.setPage(pageNr, 0.0f, 0.0f);
    }

    public String getVersion() {
        if (this.isPDF) {
            return "1." + this.reader.getPdfVersion();
        }
        return "1.3";
    }

    public PDFContent(PDFContent src, int pageNr, float width, float height, String blendColorSpace) throws IOException {
        this.reader = src.reader;
        this.output = src.output;
        this.nrOfPages = src.nrOfPages;
        this.fileName = src.fileName;
        this.isPDF = src.isPDF;
        this.blendColorSpace = blendColorSpace;
        this.setPage(pageNr, width, height);
    }

    public Content create(int pageNr, float width, float height, String blendColorSpace) throws IOException {
        return new PDFContent(this, pageNr, width, height, blendColorSpace);
    }

    public void setPage(int pageNr, float width, float height) throws IOException {
        if (pageNr < 0 && this.nrOfPages != 1) {
            throw new IOException("PDF file " + this.fileName + " has " + this.nrOfPages + " pages in stead of the expected 1");
        }
        if (pageNr == 0) {
            throw new IOException("Index " + pageNr + " is out of range, PDF file " + this.fileName + " has " + this.nrOfPages + " pages");
        }
        this.pageNr = pageNr < 0 ? 1 : pageNr;
        if (this.pageNr > this.nrOfPages) {
            this.page = null;
            this.rotate = 0;
            this.width = width;
            this.height = height;
        } else {
            this.page = this.output.getImportedPage(this.reader, this.pageNr, this.blendColorSpace);
            this.rotate = this.reader.getPageRotation(this.pageNr);
            Rectangle mediabox = this.reader.getBoxSize(this.pageNr, "media");
            this.width = mediabox.getWidth();
            this.height = mediabox.getHeight();
        }
    }

    public static String PDFToPS(String fileName) throws IOException {
        if (!ManifestGenerator.isWindows) {
            throw new IOException("Tranparency flattening is only supported on MicroSoft Windows");
        }
        File original = new File(fileName);
        File converted = new File(String.valueOf(fileName) + ".ps");
        if (!converted.exists() || converted.lastModified() < original.lastModified()) {
            ManifestGenerator.deleteWhenDone(converted);
            ActiveXComponent doc = new ActiveXComponent("AcroExch.PDDoc");
            if (doc == null) {
                throw new IOException("Transparency flattening requires Acrobat Professional");
            }
            doc.invoke("Open", original.getAbsolutePath());
            ActiveXComponent js = doc.invokeGetComponent("GetJSObject");
            js.invoke("saveAs", new Variant((Object)converted.getAbsolutePath()), new Variant((Object)"com.adobe.acrobat.ps"));
            doc.invoke("Close");
        }
        return converted.getAbsolutePath();
    }

    public static String PSToPDF(PDFOutput output, String fileName) throws IOException {
        File original = new File(fileName);
        File converted = new File(String.valueOf(fileName) + ".pdf");
        if (!converted.exists() || converted.lastModified() < original.lastModified()) {
            File logFile;
            ManifestGenerator.deleteWhenDone(converted);
            Vector<String> cmd = new Vector<String>();
            if (psConverter.equals("distiller")) {
                if (path != null) {
                    cmd.add(String.valueOf(path) + System.getProperty("file.separator") + "acrodist");
                } else {
                    cmd.add("acrodist");
                }
                cmd.add("/J");
                cmd.add(String.valueOf(ManifestGenerator.getInstallationPath()) + System.getProperty("file.separator") + "checkppml.joboptions");
                if (distillerSecuritySwitch) {
                    cmd.add("-F");
                }
                cmd.add("--deletelog:off");
                cmd.add("/N");
                cmd.add("/Q");
                cmd.add("/O");
                cmd.add(converted.getAbsolutePath());
                cmd.add(new File(fileName).getAbsolutePath());
            } else if (psConverter.equals("builtin")) {
                cmd.add("/bin/sh");
                cmd.add(String.valueOf(ManifestGenerator.getInstallationPath()) + System.getProperty("file.separator") + "pstopdf");
                cmd.add(converted.getAbsolutePath());
                cmd.add(new File(fileName).getAbsolutePath());
            } else {
                if (ManifestGenerator.isWindows) {
                    if (path != null) {
                        if (use64BitConverter) {
                            cmd.add(String.valueOf(path) + System.getProperty("file.separator") + "gswin64c");
                        } else {
                            cmd.add(String.valueOf(path) + System.getProperty("file.separator") + "gswin32c");
                        }
                    } else {
                        cmd.add("gswin32c");
                    }
                } else if (path != null) {
                    cmd.add(String.valueOf(path) + System.getProperty("file.separator") + "gs");
                } else {
                    cmd.add("gs");
                }
                cmd.add("-sDEVICE=pdfwrite");
                cmd.add("-q");
                cmd.add("-dNOPAUSE");
                cmd.add("-dNOSAFER");
                cmd.add("-dBATCH");
                cmd.add("-sOutputFile=" + converted.getAbsolutePath());
                cmd.add(String.valueOf(ManifestGenerator.getInstallationPath()) + System.getProperty("file.separator") + "checkppml.joboptions");
                cmd.add(new File(fileName).getAbsolutePath());
                cmd.add("-c");
                cmd.add("quit");
            }
            String cmdStr = "";
            int i = 0;
            while (i < cmd.size()) {
                cmdStr = String.valueOf(cmdStr) + (String)cmd.get(i) + " ";
                ++i;
            }
            Logger logger = Logger.getLogger("Parser");
            ByteArrayOutputStream messages = new ByteArrayOutputStream();
            try {
                Process p = Runtime.getRuntime().exec(cmd.toArray(new String[0]));
                p.getOutputStream().close();
                new Copier(p.getInputStream(), messages);
                new Copier(p.getErrorStream(), messages);
                if (p.waitFor() != 0) {
                    throw new IOException("exit code " + p.exitValue() + " while converting to PDF: " + messages);
                }
            }
            catch (Exception e) {
                throw new IOException("Conversion to PDF terminated abnormally:\n" + messages + e);
            }
            if (psConverter.equals("distiller") && (logFile = new File(String.valueOf(fileName) + ".log")).exists()) {
                FileInputStream input = new FileInputStream(logFile.getAbsolutePath());
                byte[] buffer = new byte[512];
                try {
                    int count;
                    while ((count = ((InputStream)input).read(buffer)) > 0) {
                        messages.write(buffer, 0, count);
                    }
                }
                catch (IOException e) {
                    Logger.getLogger("Parser").log(Level.SEVERE, "Error during distilling: " + e);
                }
                ((InputStream)input).close();
                logFile.delete();
            }
            String text = messages.toString();
            int length = text.length();
            int offset = 0;
            int locationStart = 0;
            int locationEnd = 0;
            block6: while (offset < length) {
                String location;
                int pos = text.indexOf("%%[CHECKPPML:", offset);
                if (pos < 0) {
                    String message = text.substring(offset, length - 1);
                    location = text.substring(locationStart, locationEnd);
                    logger.log(Level.WARNING, String.valueOf(location) + ": Conversion to PDF produced messages:\n" + message);
                    break;
                }
                if (pos - offset > 0) {
                    String message = text.substring(offset, pos);
                    location = text.substring(locationStart, locationEnd);
                    logger.log(Level.WARNING, String.valueOf(location) + ": Conversion to PDF produced messages:\n" + message);
                }
                locationStart = pos + 13;
                locationEnd = text.indexOf("]", pos);
                offset = locationEnd + 1;
                while (offset < length) {
                    char c = text.charAt(offset);
                    if (c != ' ' && c != '\t' && c != '\n' && c != '\r') continue block6;
                    ++offset;
                }
            }
            if (!converted.exists()) {
                throw new IOException("Conversion to PDF produced no output");
            }
        }
        return converted.getAbsolutePath();
    }

    public static PDFContent PSToPDF(PDFOutput output, String fileName, int pageNr, String blendColorSpace) throws IOException {
        String convertedFile = PDFContent.PSToPDF(output, fileName);
        return new PDFContent(output, convertedFile, pageNr, false, blendColorSpace);
    }

    public void display(PDFOutput device, AffineTransform transform) throws IOException {
        if (this.page != null) {
            if (this.isPDF) {
                device.place(this.page, this.rotate, transform);
            } else {
                device.place(this.page, 0, transform);
            }
        }
    }

    public PdfTemplate getReusableContent(PDFOutput device, String blendColorSpace) throws IOException {
        device.releaseTemplate(this.page);
        return this.page;
    }

    public boolean hasDimensions() {
        return this.isPDF;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }
}

