/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransparencyGroup;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.caslon.checkPPML.Content;
import net.caslon.checkPPML.ManifestGenerator;

public class PDFOutput {
    Document document;
    PdfWriter writer;
    PdfContentByte cb;
    String fileName;
    ICC_Profile sRGBProfile;
    ICC_Profile swopProfile;
    ICC_Profile grayProfile;
    PdfObject sRGBColorspace;
    PdfObject swopColorspace;
    PdfObject grayColorspace;
    PdfTemplate group;
    Outline currentOutline;
    int nextPageNr;

    private void startDocument() throws IOException {
        try {
            Document.compress = !ManifestGenerator.debugMode;
            this.document.open();
            this.cb = this.writer.getDirectContent();
            this.grayProfile = this.loadICCProfile("icm/gray.icm");
            this.sRGBProfile = this.loadICCProfile("icm/srgb.icm");
            this.swopProfile = this.loadICCProfile("icm/swop.icm");
            this.grayColorspace = this.loadICCProfile("icm/gray.icm", 1);
            this.sRGBColorspace = this.loadICCProfile("icm/srgb.icm", 3);
            this.swopColorspace = this.loadICCProfile("icm/swop.icm", 4);
        }
        catch (Exception e) {
            throw new IOException("Error creating PDF file " + this.fileName + ": " + e.getMessage());
        }
    }

    private PDFOutput(PDFOutput output) {
        this.document = output.document;
        this.cb = output.cb;
        this.writer = output.writer;
        this.fileName = output.fileName;
        this.grayColorspace = output.grayColorspace;
        this.sRGBColorspace = output.sRGBColorspace;
        this.swopColorspace = output.swopColorspace;
        this.grayProfile = output.grayProfile;
        this.sRGBProfile = output.sRGBProfile;
        this.swopProfile = output.swopProfile;
        this.group = output.group;
        this.currentOutline = null;
        this.nextPageNr = 1;
    }

    public PDFOutput(String title, String fileName) throws IOException {
        try {
            this.document = new Document();
            this.writer = PdfWriter.getInstance(this.document, new FileOutputStream(fileName));
            this.document.addCreator("CheckPPML " + ManifestGenerator.getVersion() + " by PODi");
            Document.compress = !ManifestGenerator.debugMode;
            this.fileName = fileName;
            this.group = null;
            this.currentOutline = null;
            this.nextPageNr = 1;
            if (title != null) {
                this.document.addTitle(title);
            }
        }
        catch (Exception e) {
            throw new IOException("Error creating PDF file " + fileName + ": " + e.getMessage());
        }
    }

    private ICC_Profile loadICCProfile(String name) throws IOException {
        InputStream ICCProfileStream = ClassLoader.getSystemResourceAsStream(name);
        return ICC_Profile.getInstance(ICCProfileStream);
    }

    private PdfObject loadICCProfile(String name, int components) throws IOException {
        int count;
        InputStream ICCProfileStream = ClassLoader.getSystemResourceAsStream(name);
        ByteArrayOutputStream profileData = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        while ((count = ICCProfileStream.read(buffer)) > 0) {
            profileData.write(buffer, 0, count);
        }
        ICCProfileStream.close();
        PdfStream profile = new PdfStream(profileData.toByteArray());
        profile.flateCompress();
        profile.put(PdfName.N, new PdfNumber(components));
        PdfArray colorSpace = new PdfArray();
        colorSpace.add(PdfName.ICCBASED);
        colorSpace.add(this.writer.addToBody(profile).getIndirectReference());
        return colorSpace;
    }

    public void close() throws IOException {
        if (this.document.isOpen()) {
            this.document.close();
        }
    }

    public void startPage(float width, float height) throws IOException {
        this.startPage(0.0f, 0.0f, width, height);
    }

    private PdfOutline addOutline(Outline outline) {
        if (outline == null) {
            return this.writer.getRootOutline();
        }
        if (outline.pdfOutline != null) {
            return outline.pdfOutline;
        }
        PdfOutline parent = this.addOutline(outline.parent);
        PdfDestination destination = new PdfDestination(2);
        destination.addPage(this.writer.getPageReference(outline.pageNr));
        outline.pdfOutline = new PdfOutline(parent, destination, outline.label);
        return outline.pdfOutline;
    }

    public void startPage(float llx, float lly, float urx, float ury) throws IOException {
        try {
            this.document.setPageSize(new Rectangle(llx, lly, urx, ury));
            if (this.document.isOpen()) {
                this.document.newPage();
            } else {
                this.startDocument();
            }
            ++this.nextPageNr;
            this.addOutline(this.currentOutline);
            this.cb.setDefaultColorspace(PdfName.DEFAULTGRAY, this.grayColorspace);
            this.cb.setDefaultColorspace(PdfName.DEFAULTRGB, this.sRGBColorspace);
            this.cb.setDefaultColorspace(PdfName.DEFAULTCMYK, this.swopColorspace);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Error creating new PDF page: " + e.getMessage());
        }
    }

    public void makeEmptyPage() throws IOException {
        this.cb.saveState();
        this.cb.restoreState();
    }

    public void save() throws IOException {
        this.cb.saveState();
    }

    public void setupClip(Area clip) throws IOException {
        double[] points = new double[6];
        if (!clip.isEmpty()) {
            PathIterator it = clip.getPathIterator(null);
            while (!it.isDone()) {
                int segmentType = it.currentSegment(points);
                if (segmentType == 0) {
                    this.cb.moveTo((float)points[0], (float)points[1]);
                } else if (segmentType == 1) {
                    this.cb.lineTo((float)points[0], (float)points[1]);
                } else if (segmentType == 4) {
                    this.cb.closePath();
                } else {
                    throw new IOException("Only area's with straight lines are currently supported");
                }
                it.next();
            }
        } else {
            this.cb.moveTo(0.0f, 0.0f);
            this.cb.closePath();
        }
        this.cb.clip();
        this.cb.newPath();
    }

    public void setupTransform(AffineTransform transform) throws IOException {
        this.cb.transform(transform);
    }

    public void restore() throws IOException {
        this.cb.restoreState();
    }

    public void place(AffineTransform transform, Area clip, Content content) throws IOException {
        this.setupClip(clip);
        content.display(this, transform);
    }

    public PdfImportedPage getImportedPage(PdfReader reader, int pageNr, String blendColorSpace) throws IOException {
        PdfImportedPage page = this.writer.getImportedPage(reader, pageNr);
        if (page != null) {
            PdfTransparencyGroup group = new PdfTransparencyGroup();
            group.setIsolated(true);
            group.setKnockout(false);
            if (blendColorSpace == null || blendColorSpace.equals("CMYK")) {
                group.put(PdfName.CS, PdfName.DEVICECMYK);
            } else if (blendColorSpace.equals("RGB")) {
                group.put(PdfName.CS, PdfName.DEVICERGB);
            }
            group.put(PdfName.NAME, new PdfString(blendColorSpace));
            page.setGroup(group);
        }
        return page;
    }

    public void place(PdfImportedPage page, int rotate, AffineTransform transform) throws IOException {
        switch (rotate) {
            case 0: {
                break;
            }
            case 90: {
                this.cb.transform(new AffineTransform(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, page.getWidth()));
                break;
            }
            case 180: {
                this.cb.transform(new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f));
                break;
            }
            case 270: {
                this.cb.transform(new AffineTransform(0.0f, 1.0f, -1.0f, 0.0f, page.getHeight(), 0.0f));
                break;
            }
            default: {
                throw new IOException("Rotation should be a multiple of 90 degrees");
            }
        }
        this.cb.addTemplate(page, (float)transform.getScaleX(), (float)transform.getShearY(), (float)transform.getShearX(), (float)transform.getScaleY(), (float)transform.getTranslateX(), (float)transform.getTranslateY());
        this.writer.releaseTemplate(page);
    }

    public void releaseTemplate(PdfTemplate page) throws IOException {
        this.writer.releaseTemplate(page);
    }

    public PdfTemplate makeReusable(float width, float height, Content content, String blendColorSpace) throws IOException {
        PdfTemplate form = PdfTemplate.createTemplate(this.writer, width, height);
        PdfTransparencyGroup transparencyGroup = new PdfTransparencyGroup();
        transparencyGroup.setIsolated(true);
        transparencyGroup.setKnockout(true);
        if (blendColorSpace == null || blendColorSpace.equals("CMYK")) {
            transparencyGroup.put(PdfName.CS, PdfName.DEVICECMYK);
        } else if (blendColorSpace.equals("RGB")) {
            transparencyGroup.put(PdfName.CS, PdfName.DEVICERGB);
        }
        transparencyGroup.put(PdfName.NAME, new PdfString(blendColorSpace));
        form.setGroup(transparencyGroup);
        PdfContentByte saved = this.cb;
        this.cb = form;
        content.display(this, new AffineTransform());
        this.cb = saved;
        this.writer.releaseTemplate(form);
        return form;
    }

    public PdfTemplate createTemplate(boolean isolated, boolean knockout, String blendColorSpace, Rectangle bbox) {
        PdfTemplate group = PdfTemplate.createTemplate(this.writer, 0.0f, 0.0f);
        group.setBoundingBox(bbox);
        PdfTransparencyGroup transparencyGroup = new PdfTransparencyGroup();
        transparencyGroup.setIsolated(isolated);
        transparencyGroup.setKnockout(knockout);
        if (blendColorSpace == null || blendColorSpace.equals("CMYK")) {
            transparencyGroup.put(PdfName.CS, PdfName.DEVICECMYK);
        } else if (blendColorSpace.equals("RGB")) {
            transparencyGroup.put(PdfName.CS, PdfName.DEVICERGB);
        }
        transparencyGroup.put(PdfName.NAME, new PdfString(blendColorSpace));
        group.setGroup(transparencyGroup);
        return group;
    }

    public PDFOutput getOutput(PdfTemplate group) {
        PDFOutput result = new PDFOutput(this);
        result.group = group;
        result.cb = result.group;
        return result;
    }

    public PDFOutput createGroup(boolean isolated, boolean knockout, String blendColorSpace, Rectangle bbox) {
        PDFOutput result = this.getOutput(this.createTemplate(isolated, knockout, blendColorSpace, bbox));
        this.cb.addTemplate(result.group, 0.0f, 0.0f);
        return result;
    }

    public PdfTemplate getGroup() {
        return this.group;
    }

    public void setBlendMode(String blendMode, double opacity, PdfTemplate softmask) {
        if (blendMode == null) {
            return;
        }
        PdfGState gstate = new PdfGState();
        gstate.setAlphaIsShape(false);
        gstate.setBlendMode(new PdfName(blendMode));
        if (softmask != null) {
            PdfDictionary smaskDict = new PdfDictionary();
            smaskDict.put(PdfName.S, new PdfName("Luminosity"));
            float[] white = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            smaskDict.put(PdfName.BC, new PdfArray(white));
            smaskDict.put(new PdfName("G"), softmask.getIndirectReference());
            gstate.put(PdfName.SMASK, smaskDict);
        } else if (opacity >= 0.0) {
            gstate.setFillOpacity((float)opacity);
        }
        this.cb.setGState(gstate);
    }

    public void endGroup() throws IOException {
        this.writer.releaseTemplate(this.group);
        this.cb = null;
    }

    public void place(PdfTemplate template, AffineTransform transform) throws IOException {
        try {
            this.cb.addTemplate(template, (float)transform.getScaleX(), (float)transform.getShearY(), (float)transform.getShearX(), (float)transform.getScaleY(), (float)transform.getTranslateX(), (float)transform.getTranslateY());
        }
        catch (Exception e) {
            throw new IOException("Error reusing template on PDF page: " + e.getMessage());
        }
    }

    public void place(Image image, AffineTransform transform) throws IOException {
        try {
            AffineTransform combined = new AffineTransform(image.matrix());
            combined.preConcatenate(transform);
            this.cb.addImage(image, (float)combined.getScaleX(), (float)combined.getShearY(), (float)combined.getShearX(), (float)combined.getScaleY(), (float)combined.getTranslateX(), (float)combined.getTranslateY());
        }
        catch (Exception e) {
            throw new IOException("Error adding image to PDF page: " + e.getMessage());
        }
    }

    public void addWaterMark(String text) throws IOException {
        try {
            BaseFont bf = BaseFont.createFont("Helvetica", "Cp1252", true);
            Rectangle rect = this.document.getPageSize();
            float width = bf.getWidthPoint(text, 1.0f);
            float ascent = bf.getAscentPoint(text, 1.0f);
            float descent = bf.getDescentPoint(text, 1.0f);
            Area bbox = new Area(new Rectangle2D.Float(0.0f, 0.0f, width, ascent + descent));
            bbox.transform(AffineTransform.getRotateInstance(0.7853981633974483));
            Rectangle2D rotatedBBox = bbox.getBounds2D();
            float size = (float)Math.min((double)rect.getWidth() / rotatedBBox.getWidth(), (double)rect.getHeight() / rotatedBBox.getHeight());
            this.cb.beginText();
            this.cb.setLineWidth(0.25f);
            this.cb.setFontAndSize(bf, size);
            this.cb.setTextRenderingMode(1);
            this.cb.showTextAligned(1, text, (rect.getRight() + rect.getLeft()) / 2.0f + 0.25f * (float)Math.sqrt(2.0) * ascent * size, (rect.getBottom() + rect.getTop()) / 2.0f - 0.25f * (float)Math.sqrt(2.0) * ascent * size, 45.0f);
            this.cb.endText();
        }
        catch (Exception e) {
            throw new IOException("Error adding watermark to PDF page: " + e.getMessage());
        }
    }

    public void startOutline(String label) {
        this.currentOutline = new Outline(this.currentOutline, label, this.nextPageNr);
    }

    public void endOutline() {
        this.currentOutline = this.currentOutline.parent;
    }

    static class Outline {
        String label;
        Outline parent;
        int pageNr;
        PdfOutline pdfOutline;

        public Outline(Outline parent, String label, int pageNr) {
            this.label = label;
            this.parent = parent;
            this.pageNr = pageNr;
            this.pdfOutline = null;
        }
    }
}

