/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfTemplate;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.caslon.checkPPML.Base64Decode;
import net.caslon.checkPPML.CompoundContent;
import net.caslon.checkPPML.Content;
import net.caslon.checkPPML.File;
import net.caslon.checkPPML.GlobalScope;
import net.caslon.checkPPML.ImageContent;
import net.caslon.checkPPML.ImpositionTemplate;
import net.caslon.checkPPML.MD5Checksum;
import net.caslon.checkPPML.ManifestGenerator;
import net.caslon.checkPPML.Object;
import net.caslon.checkPPML.Occurrence;
import net.caslon.checkPPML.PDFContent;
import net.caslon.checkPPML.PDFOutput;
import net.caslon.checkPPML.PageScope;
import net.caslon.checkPPML.ParseException;
import net.caslon.checkPPML.PositionedView;
import net.caslon.checkPPML.Resource;
import net.caslon.checkPPML.Scope;
import net.caslon.checkPPML.SheetMark;
import net.caslon.checkPPML.StreamCopy;
import net.caslon.checkPPML.TicketState;
import net.caslon.checkPPML.XMLSerialisable;
import net.caslon.checkPPML.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class Parser
implements ContentHandler,
ErrorHandler,
XMLSerialisable {
    static final float MAXDELTA = 0.5f;
    GlobalScope globalScope;
    Scope internalDataScope;
    Scope currentScope;
    Stack elements;
    Stack attributes;
    String currentElement = null;
    Scope ppmlScope;
    PDFOutput output = null;
    int outputStartPageNr;
    int outputEndPageNr;
    int currentPageNr = 0;
    PDFOutput imposedOutput;
    boolean outputPageStarted = false;
    Map fileInfoCache;
    Map contentCache;
    Map objectCache;
    String ppmlVersion = "2.2";
    Locator currentLocation;
    int ignoreContent = -1;
    int psIndex = 0;
    OutputStream psFile = null;
    OutputStream bufferedPSFile = null;
    Writer distill = null;
    String psFileName = null;
    Logger logger = Logger.getLogger("Parser");
    PositionedView reusableObjectView = null;
    PositionedView markView = null;
    PositionedView objectView = null;
    PositionedView occurrenceView = null;
    PositionedView currentView = null;
    PositionedView sheetMarkView = null;
    Object object = null;
    Object softmask = null;
    String objectLocation = null;
    String objectBlendMode = null;
    String opacity = null;
    String sourceFormat;
    String sourceTransparency;
    File sourceFile = null;
    double sourceWidth;
    double sourceHeight;
    double[] sourceClipRect = null;
    int sourceIndex = -1;
    int objectNr = 0;
    String sourceFileName = null;
    java.io.File fileDir = null;
    String resourceName = null;
    String resourceInternalName = null;
    String resourceEnvironment = null;
    String resourceScope = null;
    String resourceType = null;
    String resourceSubType = null;
    String overwriteMode = null;
    String occurrenceName = null;
    String occurrenceEnvironment = null;
    String occurrenceScope = null;
    String occurrenceBlendMode = null;
    Vector files;
    Vector resources;
    Map contentFiles;
    Object currentGroup = null;
    Vector ticketStates;
    MD5Checksum checksum = null;
    MD5Checksum sourceChecksum = null;
    OutputStreamWriter outputStream = null;
    URL baseDir = null;
    boolean zipSrc = false;
    OutputStream sourceData = null;
    TicketState currentTicketState = null;
    File ticketFile = null;
    String ticketSetID = null;
    ImpositionTemplate impositionTemplate = null;
    ImpositionTemplate savedImpositionTemplate = null;
    ImpositionTemplate currentImpositionTemplate = null;
    double hSize = 0.0;
    double vSize = 0.0;
    boolean sheetMarkOnFront = true;
    Vector imposition;
    String impositionName = null;
    HashMap prefixes;
    HashMap namespaces;
    String defaultNameSpace = null;
    boolean isGA = false;
    boolean isVDX = false;
    boolean isTestCase = false;
    XMLWriter PPMLOutputStream = null;
    XMLWriter XMLOutput = null;
    private boolean captureText;
    private String text;
    public static final String INDEXREGEXP = "[0-9]+";
    public static final String NUMBERREGEXP = "[+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)?";
    public static final String DIMENSIONSREGEXP = "[+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)?";
    public static final String POSITIONREGEXP = "[+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)?";
    public static final String BBOXREGEXP = "[+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)?";
    public static final String MATRIXREGEXP = "[+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)?";
    public static final boolean supportsImpositioning = false;

    public Parser() {
        this.globalScope = new GlobalScope();
        this.internalDataScope = new Scope(null, "PPML", "PPML", null);
        this.currentScope = this.globalScope;
        this.elements = new Stack();
        this.attributes = new Stack();
        this.files = new Vector();
        this.resources = new Vector();
        this.fileInfoCache = new HashMap();
        this.contentCache = new HashMap();
        this.objectCache = new HashMap();
        this.ticketStates = new Vector();
        this.prefixes = new HashMap();
        this.namespaces = new HashMap();
    }

    boolean inOutputRange() {
        if (this.output == null) {
            return false;
        }
        if (this.currentPageNr < this.outputStartPageNr) {
            return false;
        }
        if (this.outputEndPageNr < 0) {
            return true;
        }
        return this.currentPageNr <= this.outputEndPageNr;
    }

    public void setFileDir(String prefix) {
        this.fileDir = new java.io.File(prefix);
    }

    public void setOutput(PDFOutput driver, int fromPage, int toPage) {
        this.output = driver;
        this.outputStartPageNr = fromPage;
        this.outputEndPageNr = toPage;
    }

    public void setPPMLOutput(XMLWriter writer) {
        this.PPMLOutputStream = writer;
    }

    public void setImposedOutput(PDFOutput driver) {
        this.imposedOutput = driver;
    }

    public void setBase(URL base, boolean isZip) {
        this.baseDir = base;
        this.zipSrc = isZip;
    }

    public void setDocumentLocator(Locator locator) {
        this.currentLocation = locator;
    }

    public void startDocument() throws SAXException {
        this.ppmlScope = null;
        this.contentFiles = new HashMap();
    }

    public void endDocument() throws SAXException {
        try {
            if (this.output != null) {
                if (this.psFile != null) {
                    this.distill.close();
                    this.bufferedPSFile.flush();
                    this.bufferedPSFile.close();
                    this.psFile.close();
                    PDFContent.PSToPDF(this.output, this.psFileName);
                }
                this.generatePDF();
                this.output.close();
                this.output = null;
            }
        }
        catch (IOException e) {
            if (ManifestGenerator.debugMode) {
                e.printStackTrace(System.err);
            }
            throw new SAXException("Error during PDF writing: " + e.getMessage());
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixes.put(uri, prefix);
        this.namespaces.put(prefix, uri);
        if (prefix == null || prefix.equals("")) {
            this.defaultNameSpace = uri;
        }
        if (this.PPMLOutputStream != null) {
            this.PPMLOutputStream.addPrefix(prefix, uri);
        }
        if (this.XMLOutput != null) {
            this.XMLOutput.addPrefix(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.prefixes.remove(this.namespaces.get(prefix));
        this.namespaces.remove(prefix);
    }

    private String getLocation() {
        int lineNr = this.currentLocation.getLineNumber();
        int columnNr = this.currentLocation.getColumnNumber();
        if (columnNr < 0) {
            return "Line " + lineNr;
        }
        return "Line " + lineNr + ", column " + columnNr;
    }

    public void warning(String location, String msg) {
        this.logger.log(Level.WARNING, String.valueOf(location) + ": " + msg);
    }

    public void warning(String msg) {
        this.warning(this.getLocation(), msg);
    }

    public void error(String location, String msg) {
        this.logger.log(Level.SEVERE, String.valueOf(location) + ": " + msg);
    }

    public void error(String msg) {
        this.error(this.getLocation(), msg);
    }

    public void startElement(String namespace, String localName, String qName, Attributes atts) throws SAXException {
        if (this.ignoreContent > 0) {
            this.elements.push(localName);
            this.attributes.push(new AttributesImpl(atts));
            return;
        }
        try {
            block182: {
                File file;
                block208: {
                    String value;
                    block212: {
                        String size;
                        block211: {
                            double d;
                            block210: {
                                block209: {
                                    double d2;
                                    block207: {
                                        block206: {
                                            block205: {
                                                block204: {
                                                    block203: {
                                                        String environment;
                                                        Occurrence occurrence;
                                                        block202: {
                                                            block201: {
                                                                block200: {
                                                                    block199: {
                                                                        block198: {
                                                                            block197: {
                                                                                block196: {
                                                                                    block195: {
                                                                                        String dimensions;
                                                                                        String[] numbers;
                                                                                        block194: {
                                                                                            block193: {
                                                                                                block192: {
                                                                                                    block191: {
                                                                                                        String environment2;
                                                                                                        block190: {
                                                                                                            String fileSrc;
                                                                                                            block189: {
                                                                                                                block188: {
                                                                                                                    block187: {
                                                                                                                        block186: {
                                                                                                                            block185: {
                                                                                                                                block184: {
                                                                                                                                    block183: {
                                                                                                                                        block181: {
                                                                                                                                            String prefix;
                                                                                                                                            String attributeNamespace;
                                                                                                                                            int index;
                                                                                                                                            if (this.PPMLOutputStream != null) {
                                                                                                                                                if (namespace != null && !namespace.equals(this.defaultNameSpace)) {
                                                                                                                                                    String prefix2 = (String)this.prefixes.get(namespace);
                                                                                                                                                    this.PPMLOutputStream.startElement(String.valueOf(prefix2) + ":" + localName);
                                                                                                                                                } else {
                                                                                                                                                    this.PPMLOutputStream.startElement(localName);
                                                                                                                                                }
                                                                                                                                                int attributeCount = atts.getLength();
                                                                                                                                                if (attributeCount > 0) {
                                                                                                                                                    index = 0;
                                                                                                                                                    while (index < attributeCount) {
                                                                                                                                                        attributeNamespace = atts.getURI(index);
                                                                                                                                                        if (attributeNamespace != null && !attributeNamespace.equals("") && !attributeNamespace.equals(this.defaultNameSpace)) {
                                                                                                                                                            prefix = (String)this.prefixes.get(attributeNamespace);
                                                                                                                                                            this.PPMLOutputStream.writeAttribute(String.valueOf(prefix) + ":" + atts.getLocalName(index), atts.getValue(index));
                                                                                                                                                        } else {
                                                                                                                                                            this.PPMLOutputStream.writeAttribute(atts.getLocalName(index), atts.getValue(index));
                                                                                                                                                        }
                                                                                                                                                        ++index;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            if (this.XMLOutput != null) {
                                                                                                                                                if (namespace != null && !namespace.equals(this.defaultNameSpace)) {
                                                                                                                                                    String prefix3 = (String)this.prefixes.get(namespace);
                                                                                                                                                    this.XMLOutput.startElement(String.valueOf(prefix3) + ":" + localName);
                                                                                                                                                } else {
                                                                                                                                                    this.XMLOutput.startElement(localName);
                                                                                                                                                }
                                                                                                                                                int attributeCount = atts.getLength();
                                                                                                                                                if (attributeCount > 0) {
                                                                                                                                                    index = 0;
                                                                                                                                                    while (index < attributeCount) {
                                                                                                                                                        attributeNamespace = atts.getURI(index);
                                                                                                                                                        if (attributeNamespace != null && !attributeNamespace.equals("") && !attributeNamespace.equals(this.defaultNameSpace)) {
                                                                                                                                                            prefix = (String)this.prefixes.get(attributeNamespace);
                                                                                                                                                            this.XMLOutput.writeAttribute(String.valueOf(prefix) + ":" + atts.getLocalName(index), atts.getValue(index));
                                                                                                                                                        } else {
                                                                                                                                                            this.XMLOutput.writeAttribute(atts.getLocalName(index), atts.getValue(index));
                                                                                                                                                        }
                                                                                                                                                        ++index;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                this.elements.push(localName);
                                                                                                                                                this.attributes.push(new AttributesImpl(atts));
                                                                                                                                                return;
                                                                                                                                            }
                                                                                                                                            if (!localName.equals("PPML")) break block181;
                                                                                                                                            String label = atts.getValue("Label");
                                                                                                                                            this.ppmlScope = new Scope(this.currentScope, localName, "PPML", label);
                                                                                                                                            this.ppmlVersion = atts.getValue("Version");
                                                                                                                                            this.currentScope = this.ppmlScope;
                                                                                                                                            this.currentTicketState = this.currentScope.getTicketState();
                                                                                                                                            if (this.isVDX && label == null) {
                                                                                                                                                this.warning("In PPML/VDX the PPML element should have a Label attribute");
                                                                                                                                            }
                                                                                                                                            break block182;
                                                                                                                                        }
                                                                                                                                        if (!localName.equals("JOB")) break block183;
                                                                                                                                        this.currentScope = new Scope(this.currentScope, "JOB", "Job", atts.getValue("Label"));
                                                                                                                                        this.currentTicketState = this.currentScope.getTicketState();
                                                                                                                                        break block182;
                                                                                                                                    }
                                                                                                                                    if (!localName.equals("DOCUMENT_SET")) break block184;
                                                                                                                                    this.currentScope = new Scope(this.currentScope, "DOCUMENT_SET", "DocSet", atts.getValue("Label"));
                                                                                                                                    this.currentTicketState = this.currentScope.getTicketState();
                                                                                                                                    break block182;
                                                                                                                                }
                                                                                                                                if (!localName.equals("DOCUMENT")) break block185;
                                                                                                                                this.currentScope = new Scope(this.currentScope, "DOCUMENT", "Document", atts.getValue("Label"));
                                                                                                                                this.currentTicketState = this.currentScope.getTicketState();
                                                                                                                                int docCopies = 1;
                                                                                                                                String copies = atts.getValue("DocumentCopies");
                                                                                                                                if (copies != null) {
                                                                                                                                    if (copies.matches(INDEXREGEXP)) {
                                                                                                                                        docCopies = Integer.parseInt(copies);
                                                                                                                                    } else {
                                                                                                                                        this.error("Illegal DocumentCopies " + copies + " specified");
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                this.currentScope.setCopies(docCopies);
                                                                                                                                String dimensions2 = atts.getValue("Dimensions");
                                                                                                                                if (dimensions2 != null) {
                                                                                                                                    if (dimensions2.matches("[+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)?")) {
                                                                                                                                        String[] numbers2 = dimensions2.split(" ");
                                                                                                                                        double[] pageTrimBox = new double[]{0.0, 0.0, Double.parseDouble(numbers2[0]), Double.parseDouble(numbers2[1])};
                                                                                                                                        this.currentScope.setTrimBox(pageTrimBox);
                                                                                                                                        this.currentScope.setBleedBox(pageTrimBox);
                                                                                                                                    } else {
                                                                                                                                        this.error("Illegal dimensions " + dimensions2 + " specified");
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                break block182;
                                                                                                                            }
                                                                                                                            if (!localName.equals("PAGE")) break block186;
                                                                                                                            ++this.currentPageNr;
                                                                                                                            boolean knockout = true;
                                                                                                                            if (atts.getValue("Knockout") != null && atts.getValue("Knockout").equals("No")) {
                                                                                                                                knockout = false;
                                                                                                                            }
                                                                                                                            this.currentScope = new PageScope(this.currentScope, atts.getValue("Label"), atts.getValue("BlendColorSpace"), knockout);
                                                                                                                            this.currentTicketState = this.currentScope.getTicketState();
                                                                                                                            String dimensions3 = atts.getValue("Dimensions");
                                                                                                                            if (dimensions3 != null) {
                                                                                                                                if (dimensions3.matches("[+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)?")) {
                                                                                                                                    numbers = dimensions3.split(" ");
                                                                                                                                    double[] pageTrimBox = new double[]{0.0, 0.0, Double.parseDouble(numbers[0]), Double.parseDouble(numbers[1])};
                                                                                                                                    this.currentScope.setTrimBox(pageTrimBox);
                                                                                                                                    this.currentScope.setBleedBox(pageTrimBox);
                                                                                                                                } else {
                                                                                                                                    this.error("Illegal dimensions " + dimensions3 + "specified");
                                                                                                                                }
                                                                                                                            }
                                                                                                                            break block182;
                                                                                                                        }
                                                                                                                        if (!localName.equals("PRINT_LAYOUT")) break block187;
                                                                                                                        this.error("PPML Impositioning is not supported");
                                                                                                                        this.ignoreContent = this.elements.size();
                                                                                                                        break block182;
                                                                                                                    }
                                                                                                                    if (!localName.equals("PAGE_DESIGN") && !localName.equals("PAGE_LAYOUT")) break block188;
                                                                                                                    String trimbox = atts.getValue("TrimBox");
                                                                                                                    if (trimbox != null && trimbox.matches(BBOXREGEXP)) {
                                                                                                                        String[] numbers3 = trimbox.split(" ");
                                                                                                                        double[] pageTrimBox = new double[]{Double.parseDouble(numbers3[0]), Double.parseDouble(numbers3[1]), Double.parseDouble(numbers3[2]), Double.parseDouble(numbers3[3])};
                                                                                                                        this.currentScope.setTrimBox(pageTrimBox);
                                                                                                                        this.currentScope.setBleedBox(pageTrimBox);
                                                                                                                    } else {
                                                                                                                        this.error("Illegal TrimBox " + trimbox + " specified");
                                                                                                                    }
                                                                                                                    String bleedbox = atts.getValue("BleedBox");
                                                                                                                    if (bleedbox != null) {
                                                                                                                        if (bleedbox.matches(BBOXREGEXP)) {
                                                                                                                            numbers = bleedbox.split(" ");
                                                                                                                            double[] pageBleedBox = new double[]{Double.parseDouble(numbers[0]), Double.parseDouble(numbers[1]), Double.parseDouble(numbers[2]), Double.parseDouble(numbers[3])};
                                                                                                                            this.currentScope.setBleedBox(pageBleedBox);
                                                                                                                        } else {
                                                                                                                            this.error("Illegal BleedBox " + bleedbox + "specified");
                                                                                                                        }
                                                                                                                    }
                                                                                                                    break block182;
                                                                                                                }
                                                                                                                if (!localName.equals("IMPOSITION")) break block189;
                                                                                                                this.impositionTemplate = new ImpositionTemplate();
                                                                                                                this.impositionName = atts.getValue("Name");
                                                                                                                break block182;
                                                                                                            }
                                                                                                            if (localName.equals("SUPPLIED_RESOURCES") || localName.equals("REQUIRED_RESOURCES")) break block182;
                                                                                                            if (!localName.equals("SUPPLIED_RESOURCE")) break block190;
                                                                                                            this.resourceName = atts.getValue("Name");
                                                                                                            this.resourceInternalName = atts.getValue("ResourceName");
                                                                                                            this.resourceType = atts.getValue("Type");
                                                                                                            this.resourceSubType = atts.getValue("SubType");
                                                                                                            this.resourceScope = atts.getValue("Scope");
                                                                                                            this.resourceEnvironment = atts.getValue("Environment");
                                                                                                            this.overwriteMode = atts.getValue("Overwrite");
                                                                                                            if (this.resourceScope != null && !this.resourceScope.equals("Global")) {
                                                                                                                if (this.resourceEnvironment != null) {
                                                                                                                    this.warning("The Environment attribute is only valid for global scope definitions.");
                                                                                                                }
                                                                                                                if (this.overwriteMode != null) {
                                                                                                                    this.warning("The Overwrite attribute is only valid for global scope definitions.");
                                                                                                                }
                                                                                                            }
                                                                                                            if ((this.sourceFormat = atts.getValue("Format")) == null) {
                                                                                                                this.error("No Format specified");
                                                                                                            }
                                                                                                            if ((fileSrc = atts.getValue("Src")) != null) {
                                                                                                                try {
                                                                                                                    fileSrc = URLDecoder.decode(fileSrc);
                                                                                                                    File file2 = this.useExternalSrc(fileSrc, false);
                                                                                                                    this.files.add(file2);
                                                                                                                    this.contentFiles.put(fileSrc, file2);
                                                                                                                }
                                                                                                                catch (IOException e) {
                                                                                                                    this.error("Can't retrieve external data from " + fileSrc + ": " + e.getMessage());
                                                                                                                }
                                                                                                            }
                                                                                                            if (ManifestGenerator.fixProlog && this.resourceType.equals("ProcSet")) {
                                                                                                                this.resourceSubType = "Prolog";
                                                                                                                this.warning("Converting ProcSet to Prolog.");
                                                                                                            }
                                                                                                            break block182;
                                                                                                        }
                                                                                                        if (!localName.equals("SUPPLIED_RESOURCE_REF")) break block191;
                                                                                                        String name = atts.getValue("Name");
                                                                                                        Resource resource = this.currentScope.findResource(name, environment2 = atts.getValue("Environment"));
                                                                                                        if (resource == null) {
                                                                                                            this.error("Can't locate a resource with name " + name);
                                                                                                        } else {
                                                                                                            try {
                                                                                                                this.currentScope.requireResource(resource);
                                                                                                            }
                                                                                                            catch (Exception e) {
                                                                                                                this.error(e.getMessage());
                                                                                                            }
                                                                                                        }
                                                                                                        break block182;
                                                                                                    }
                                                                                                    if (!localName.equals("REUSABLE_OBJECT")) break block192;
                                                                                                    try {
                                                                                                        this.reusableObjectView = new PositionedView("0 0");
                                                                                                    }
                                                                                                    catch (ParseException e) {
                                                                                                        this.error(e.getMessage());
                                                                                                        this.reusableObjectView = new PositionedView();
                                                                                                    }
                                                                                                    this.currentGroup = new Object(this.getLocation(), this.currentGroup, "Normal", atts.getValue("BlendColorSpace"), !"No".equals(atts.getValue("Knockout")), !"No".equals(atts.getValue("Isolated")));
                                                                                                    break block182;
                                                                                                }
                                                                                                if (!localName.equals("MARK")) break block193;
                                                                                                double[] pageTrimBox = this.currentScope.getTrimBox();
                                                                                                if (pageTrimBox == null) {
                                                                                                    this.error("PAGE has no trim box, setting to A4");
                                                                                                    pageTrimBox = new double[]{0.0, 0.0, 595.0, 842.0};
                                                                                                }
                                                                                                try {
                                                                                                    this.markView = new PositionedView(atts.getValue("Position"));
                                                                                                }
                                                                                                catch (ParseException e) {
                                                                                                    this.error(e.getMessage());
                                                                                                    this.markView = new PositionedView();
                                                                                                }
                                                                                                this.currentGroup = new Object(this.getLocation(), this.currentGroup, atts.getValue("BlendMode"), atts.getValue("BlendColorSpace"), !"No".equals(atts.getValue("Knockout")), !"No".equals(atts.getValue("Isolated")));
                                                                                                break block182;
                                                                                            }
                                                                                            if (!localName.equals("OBJECT")) break block194;
                                                                                            try {
                                                                                                this.objectView = new PositionedView(atts.getValue("Position"));
                                                                                                this.objectLocation = this.getLocation();
                                                                                            }
                                                                                            catch (ParseException e) {
                                                                                                this.error(e.getMessage());
                                                                                                this.objectView = new PositionedView();
                                                                                            }
                                                                                            this.objectBlendMode = atts.getValue("BlendMode");
                                                                                            break block182;
                                                                                        }
                                                                                        if (!localName.equals("SOURCE")) break block195;
                                                                                        this.sourceFormat = atts.getValue("Format");
                                                                                        if (this.sourceFormat == null) {
                                                                                            this.error("No Format specified");
                                                                                        }
                                                                                        if (!(this.sourceFormat.equals("application/postscript") || this.sourceFormat.equals("application/pdf") || this.sourceFormat.equals("image/tiff") || this.sourceFormat.equals("image/jpeg"))) {
                                                                                            if (this.isGA) {
                                                                                                this.error("Unsupported content type: " + this.sourceFormat);
                                                                                            } else {
                                                                                                this.warning("COMPATIBILITY: non GA content type: " + this.sourceFormat);
                                                                                            }
                                                                                        }
                                                                                        if ((dimensions = atts.getValue("Dimensions")) != null && dimensions.matches("[+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)?")) {
                                                                                            String[] numbers4 = dimensions.split(" ");
                                                                                            this.sourceWidth = Double.parseDouble(numbers4[0]);
                                                                                            this.sourceHeight = Double.parseDouble(numbers4[1]);
                                                                                        } else {
                                                                                            this.sourceWidth = 0.0;
                                                                                            this.sourceHeight = 0.0;
                                                                                            this.error("Illegal dimensions " + dimensions + " specified");
                                                                                        }
                                                                                        String clipbox = atts.getValue("ClippingBox");
                                                                                        if (clipbox != null) {
                                                                                            if (clipbox.matches(BBOXREGEXP)) {
                                                                                                numbers = clipbox.split(" ");
                                                                                                this.sourceClipRect = new double[4];
                                                                                                this.sourceClipRect[0] = Double.parseDouble(numbers[0]);
                                                                                                this.sourceClipRect[1] = Double.parseDouble(numbers[1]);
                                                                                                this.sourceClipRect[2] = Double.parseDouble(numbers[2]);
                                                                                                this.sourceClipRect[3] = Double.parseDouble(numbers[3]);
                                                                                            } else {
                                                                                                this.error("Illegal ClippingBox " + clipbox + " specified");
                                                                                            }
                                                                                        } else {
                                                                                            this.sourceClipRect = null;
                                                                                        }
                                                                                        this.sourceTransparency = atts.getValue("Transparency");
                                                                                        if (this.currentElement != null && this.currentElement.equals("SOFTMASK") && !this.sourceTransparency.equals("None")) {
                                                                                            this.error("A SOURCE for a SOFTMASK can not preserve transparency information");
                                                                                        }
                                                                                        break block182;
                                                                                    }
                                                                                    if (!localName.equals("REUSABLE_INTERNAL_DATA")) break block196;
                                                                                    this.sourceFormat = atts.getValue("Format");
                                                                                    try {
                                                                                        if (this.sourceChecksum == null) {
                                                                                            this.setupSourceConcatenation();
                                                                                        }
                                                                                    }
                                                                                    catch (IOException e) {
                                                                                        throw new SAXException("Can't save REUSABLE_INTERNAL_DATA content", e);
                                                                                    }
                                                                                    try {
                                                                                        this.checksum = new MD5Checksum(this.sourceChecksum);
                                                                                    }
                                                                                    catch (NoSuchAlgorithmException e) {
                                                                                        throw new SAXException("Can't load MD5 checksum class");
                                                                                    }
                                                                                    String encoding = atts.getValue("Encoding");
                                                                                    if (encoding != null && encoding.equals("Base64")) {
                                                                                        this.outputStream = new OutputStreamWriter((OutputStream)new Base64Decode(this.checksum), "ISO-8859-1");
                                                                                    } else {
                                                                                        if (encoding != null && !encoding.equals("None")) {
                                                                                            this.error("Unknown Encoding " + encoding + " specified");
                                                                                        }
                                                                                        try {
                                                                                            this.outputStream = new OutputStreamWriter((OutputStream)new MD5Checksum(this.sourceChecksum), "UTF8");
                                                                                        }
                                                                                        catch (NoSuchAlgorithmException e) {
                                                                                            throw new SAXException("Can't load MD5 checksum class");
                                                                                        }
                                                                                    }
                                                                                }
                                                                                if (!localName.equals("INTERNAL_DATA")) break block197;
                                                                                try {
                                                                                    if (this.sourceChecksum == null) {
                                                                                        this.setupSourceConcatenation();
                                                                                    }
                                                                                }
                                                                                catch (IOException e) {
                                                                                    throw new SAXException("Can't save SOURCE content", e);
                                                                                }
                                                                                try {
                                                                                    this.checksum = new MD5Checksum(this.sourceChecksum);
                                                                                }
                                                                                catch (NoSuchAlgorithmException e) {
                                                                                    throw new SAXException("Can't load MD5 checksum class");
                                                                                }
                                                                                String encoding = atts.getValue("Encoding");
                                                                                if (encoding != null && encoding.equals("Base64")) {
                                                                                    this.outputStream = new OutputStreamWriter((OutputStream)new Base64Decode(this.checksum), "ISO-8859-1");
                                                                                } else {
                                                                                    if (encoding != null && !encoding.equals("None")) {
                                                                                        this.error("Unknown Encoding " + encoding + " specified");
                                                                                    }
                                                                                    try {
                                                                                        this.outputStream = new OutputStreamWriter((OutputStream)new MD5Checksum(this.sourceChecksum), "UTF8");
                                                                                    }
                                                                                    catch (NoSuchAlgorithmException e) {
                                                                                        throw new SAXException("Can't load MD5 checksum class");
                                                                                    }
                                                                                }
                                                                            }
                                                                            if (!localName.equals("INTERNAL_DATA_REF")) break block198;
                                                                            Resource resource = this.internalDataScope.findResource(atts.getValue("Ref"), null);
                                                                            if (resource == null) {
                                                                                this.error("Can't locate an REUSABLE_INTERNAL_DATA with name " + atts.getValue("Ref"));
                                                                            } else {
                                                                                java.io.File fileSrc = new java.io.File(resource.getFileName());
                                                                                file = this.useExternalSrc(fileSrc.toURL().toExternalForm(), true);
                                                                                this.files.add(file);
                                                                                this.contentFiles.put(fileSrc, file);
                                                                            }
                                                                            this.sourceIndex = -1;
                                                                            break block182;
                                                                        }
                                                                        if (!localName.equals("EXTERNAL_DATA")) break block199;
                                                                        String fileSrc = atts.getValue("Src");
                                                                        if (fileSrc != null) {
                                                                            try {
                                                                                fileSrc = URLDecoder.decode(fileSrc);
                                                                                File file3 = this.useExternalSrc(fileSrc, true);
                                                                                this.files.add(file3);
                                                                                this.contentFiles.put(fileSrc, file3);
                                                                            }
                                                                            catch (IOException e) {
                                                                                this.error("Can't retrieve external data from " + fileSrc + ": " + e.getMessage());
                                                                            }
                                                                        } else {
                                                                            this.error("No Src specified");
                                                                        }
                                                                        break block182;
                                                                    }
                                                                    if (!localName.equals("EXTERNAL_DATA_ARRAY")) break block200;
                                                                    String fileSrc = atts.getValue("Src");
                                                                    if (fileSrc != null) {
                                                                        try {
                                                                            fileSrc = URLDecoder.decode(fileSrc);
                                                                            File file4 = this.useExternalSrc(fileSrc, false);
                                                                            this.files.add(file4);
                                                                            this.contentFiles.put(fileSrc, file4);
                                                                        }
                                                                        catch (IOException e) {
                                                                            this.error("Can't retrieve external data from " + fileSrc + ": " + e.getMessage());
                                                                        }
                                                                    } else {
                                                                        this.error("No Src specified");
                                                                    }
                                                                    String index = atts.getValue("Index");
                                                                    if (index != null) {
                                                                        if (index.matches(INDEXREGEXP)) {
                                                                            this.sourceIndex = Integer.parseInt(index);
                                                                        } else {
                                                                            this.error("Invalid Index " + index + " specified");
                                                                            this.sourceIndex = 1;
                                                                        }
                                                                    } else {
                                                                        this.sourceIndex = -1;
                                                                    }
                                                                    if (this.isVDX && this.sourceIndex <= 1) {
                                                                        this.error("The first page of a PPML/VDX layout file shall not be referenced");
                                                                    }
                                                                    break block182;
                                                                }
                                                                if (!localName.equals("OCCURRENCE_LIST")) break block201;
                                                                this.currentGroup.setView(this.reusableObjectView);
                                                                break block182;
                                                            }
                                                            if (!localName.equals("OCCURRENCE")) break block202;
                                                            try {
                                                                this.occurrenceView = new PositionedView("0 0");
                                                            }
                                                            catch (ParseException e) {
                                                                this.error(e.getMessage());
                                                                this.occurrenceView = new PositionedView();
                                                            }
                                                            this.occurrenceName = atts.getValue("Name");
                                                            if (this.occurrenceName == null) {
                                                                this.error("No Name specified for the occurrence");
                                                            }
                                                            this.occurrenceEnvironment = atts.getValue("Environment");
                                                            this.occurrenceScope = atts.getValue("Scope");
                                                            this.overwriteMode = atts.getValue("Overwrite");
                                                            this.occurrenceBlendMode = atts.getValue("BlendMode");
                                                            if (this.occurrenceScope != null && !this.occurrenceScope.equals("Global")) {
                                                                if (this.occurrenceEnvironment != null) {
                                                                    this.warning("The Environment attribute is only valid for global scope definitions.");
                                                                }
                                                                if (this.overwriteMode != null) {
                                                                    this.warning("The Overwrite attribute is only valid for global scope definitions.");
                                                                }
                                                            }
                                                            break block182;
                                                        }
                                                        if (!localName.equals("OCCURRENCE_REF")) break block203;
                                                        String name = atts.getValue("Ref");
                                                        if (name == null) {
                                                            this.error("No Name specified for the occurrence");
                                                        }
                                                        if ((occurrence = this.currentScope.findOccurrence(name, environment = atts.getValue("Environment"))) != null) {
                                                            if (!occurrence.compatible(this.currentTicketState)) {
                                                                this.error("The ticket states for the occurrence named " + name + " (" + environment + ") are incompatible with the " + "current ticket state.");
                                                            }
                                                            if (this.currentElement.equals("SHEET_MARK")) {
                                                                this.currentImpositionTemplate.addMark(new SheetMark(this.sheetMarkOnFront, occurrence, this.sheetMarkView.getTransform()));
                                                                this.sheetMarkView = null;
                                                            } else {
                                                                this.currentGroup.addObject(new Object(name, environment, occurrence.getObject()));
                                                            }
                                                        } else {
                                                            this.error("Can't find an occurrence named " + name + " (" + environment + ")");
                                                        }
                                                        break block182;
                                                    }
                                                    if (!localName.equals("VIEW")) break block204;
                                                    if (this.currentElement.equals("MARK")) {
                                                        this.currentView = this.markView;
                                                    } else if (this.currentElement.equals("OBJECT")) {
                                                        this.currentView = this.objectView;
                                                    } else if (this.currentElement.equals("OCCURRENCE")) {
                                                        this.currentView = this.occurrenceView;
                                                    } else if (this.currentElement.equals("REUSABLE_OBJECT")) {
                                                        this.currentView = this.reusableObjectView;
                                                    } else {
                                                        this.currentView = new PositionedView();
                                                        this.error("VIEW used in unknown context " + this.currentElement);
                                                    }
                                                    break block182;
                                                }
                                                if (!localName.equals("TRANSFORM")) break block205;
                                                try {
                                                    this.currentView.setTransform(atts.getValue("Matrix"));
                                                }
                                                catch (ParseException e) {
                                                    this.error(e.getMessage());
                                                }
                                                break block182;
                                            }
                                            if (!localName.equals("CLIP_RECT")) break block206;
                                            try {
                                                this.currentView.setClipRect(atts.getValue("Rectangle"));
                                            }
                                            catch (ParseException e) {
                                                this.error(e.getMessage());
                                            }
                                            break block182;
                                        }
                                        if (!localName.equals("SOFTMASK")) break block207;
                                        this.opacity = atts.getValue("Opacity");
                                        if (this.opacity != null) {
                                            this.object = new Object(this.getLocation(), Double.parseDouble(this.opacity));
                                        }
                                        this.softmask = null;
                                        break block182;
                                    }
                                    if (!localName.equals("SHEET_LAYOUT")) break block208;
                                    size = atts.getValue("HSize");
                                    if (size == null || !size.matches(NUMBERREGEXP)) break block209;
                                    this.hSize = Double.parseDouble(size);
                                    if (!(d2 <= 0.0)) break block210;
                                }
                                this.error("Illegal sheet width of " + size + " specified.");
                                this.hSize = -1.0;
                            }
                            if ((size = atts.getValue("VSize")) == null || !size.matches(NUMBERREGEXP)) break block211;
                            this.vSize = Double.parseDouble(size);
                            if (!(d <= 0.0)) break block212;
                        }
                        this.error("Illegal sheet height of " + size + " specified.");
                        this.vSize = -1.0;
                    }
                    if ((value = atts.getValue("GangDocuments")) != null) {
                        if (value.equals("Yes")) {
                            this.currentImpositionTemplate.gangDocumentsPerSet();
                        } else if (!value.equals("No")) {
                            this.error("Illegal value " + value + " for GangDocuments specified.");
                        }
                    }
                    this.imposition = new Vector();
                    break block182;
                }
                if (localName.equals("SHEET_MARK")) {
                    try {
                        this.sheetMarkView = new PositionedView(atts.getValue("Position"));
                    }
                    catch (Exception e) {
                        this.error(e.getMessage());
                        this.sheetMarkView = new PositionedView("0 0");
                    }
                    String face = atts.getValue("Face");
                    if (face == null) {
                        this.sheetMarkOnFront = true;
                    } else if (face.equals("Up")) {
                        this.sheetMarkOnFront = true;
                    } else if (face.equals("Dn")) {
                        this.sheetMarkOnFront = false;
                    } else {
                        this.error("Invalid face " + face + " specified");
                        this.sheetMarkOnFront = true;
                    }
                } else if (!localName.equals("PROCESSOR") && !localName.equals("FONT")) {
                    if (localName.equals("PRIVATE_INFO")) {
                        if (atts.getValue("Creator").equals("PODi") && atts.getValue("Identifier").equals("Testcase")) {
                            this.isTestCase = true;
                        }
                        if (atts.getValue("Creator").equals("GTS_PPMLVDX_Writer") && atts.getValue("Identifier").equals("SubstrateType")) {
                            this.captureText = true;
                            this.text = "";
                        }
                    } else if (localName.equals("TICKET_REF")) {
                        String extId = atts.getValue("ExtIDRef");
                        String setName = atts.getValue("Ref");
                        if (extId == null && setName == null) {
                            this.error("No ExtIDRef or Ref specified for the TICKET_REF");
                        }
                        if (setName != null) {
                            TicketState set = this.currentScope.findTicketSet(setName);
                            if (set != null) {
                                this.currentTicketState.addTicketSet(set);
                            }
                        } else {
                            this.currentTicketState.addTicketRef(extId);
                        }
                    } else if (localName.equals("TICKET_SET")) {
                        this.ticketSetID = atts.getValue("ID");
                        if (this.ticketSetID == null) {
                            this.error("No ID specified for the TICKET_SET");
                        }
                        this.currentTicketState = new TicketState();
                    } else if (localName.equals("TICKET_STATE")) {
                        this.currentTicketState = new TicketState();
                    } else if (localName.equals("TICKET")) {
                        this.sourceFormat = atts.getValue("Format");
                        if (this.sourceFormat == null) {
                            this.error("No Format specified");
                        }
                    } else if (localName.equals("CONFORMANCE")) {
                        String subset = atts.getValue("Subset");
                        if (subset.equals("GA")) {
                            this.isGA = true;
                        }
                    } else if (localName.equals("PPMLVDX")) {
                        this.isVDX = true;
                    } else if (!localName.equals("ContentBindingTable") && !localName.equals("Layout")) {
                        if (localName.equals("Self")) {
                            String intendedColor;
                            String src = atts.getValue("Src");
                            if (src == null) {
                                src = atts.getValue("URI");
                            }
                            if (!(intendedColor = atts.getValue("IntendedColor")).equals("true")) {
                                this.warning("PPML/VDX requires the IntendedColor attribute to be set to true");
                            }
                            this.sourceFormat = "application/pdf";
                            file = this.useExternalSrc(this.baseDir.toString(), false);
                            this.fileInfoCache.put(new URL(this.baseDir, src).toString(), file);
                            this.sourceFormat = null;
                            this.sourceIndex = -1;
                            this.sourceChecksum = null;
                            this.sourceFile = null;
                            this.sourceFileName = null;
                        } else if (localName.equals("JDF")) {
                            this.ignoreContent = this.elements.size();
                        } else {
                            this.error("Element " + localName + " NOT handled yet");
                            this.ignoreContent = this.elements.size();
                        }
                    }
                }
            }
            this.elements.push(localName);
            this.attributes.push(new AttributesImpl(atts));
            this.currentElement = localName;
        }
        catch (Exception e) {
            if (ManifestGenerator.debugMode) {
                e.printStackTrace();
            }
            throw new SAXException(e);
        }
    }

    public void endElement(String namespace, String localName, String qName) throws SAXException {
        block90: {
            this.elements.pop();
            Attributes atts = (Attributes)this.attributes.pop();
            this.currentElement = this.elements.size() > 0 ? (String)this.elements.peek() : null;
            try {
                String checksum;
                String prefix;
                if (this.ignoreContent > 0 && this.elements.size() == this.ignoreContent) {
                    this.ignoreContent = -1;
                    return;
                }
                if (this.PPMLOutputStream != null) {
                    if (namespace != null && !namespace.equals(this.defaultNameSpace)) {
                        prefix = (String)this.prefixes.get(namespace);
                        this.PPMLOutputStream.endElement(String.valueOf(prefix) + ":" + localName);
                    } else {
                        this.PPMLOutputStream.endElement(localName);
                    }
                }
                if (this.XMLOutput != null && !localName.equals("INTERNAL_DATA")) {
                    if (namespace != null && !namespace.equals(this.defaultNameSpace)) {
                        prefix = (String)this.prefixes.get(namespace);
                        this.XMLOutput.endElement(String.valueOf(prefix) + ":" + localName);
                    } else {
                        this.XMLOutput.endElement(localName);
                    }
                    return;
                }
                if (localName.equals("PPML")) {
                    this.currentScope = this.currentScope.getParent();
                    this.currentTicketState = this.currentScope.getTicketState();
                    break block90;
                }
                if (localName.equals("DOCUMENT")) {
                    this.currentScope = this.currentScope.getParent();
                    this.currentTicketState = this.currentScope.getTicketState();
                    break block90;
                }
                if (localName.equals("JOB") || localName.equals("DOCUMENT_SET")) {
                    this.currentScope = this.currentScope.getParent();
                    this.currentTicketState = this.currentScope.getTicketState();
                    if (this.currentImpositionTemplate != null && this.imposedOutput != null) {
                        this.currentImpositionTemplate.generate(this.imposedOutput, this, this.currentScope.getNrOfChildren());
                    }
                    break block90;
                }
                if (localName.equals("PAGE")) {
                    double[] pageTrimBox = this.currentScope.getTrimBox();
                    this.currentScope = this.currentScope.getParent();
                    this.currentTicketState = this.currentScope.getTicketState();
                    break block90;
                }
                if (localName.equals("REUSABLE_OBJECT")) {
                    this.currentGroup = this.currentGroup.parent;
                    this.reusableObjectView = null;
                    break block90;
                }
                if (localName.equals("MARK")) {
                    if (this.markView == null) {
                        try {
                            this.markView = new PositionedView(atts.getValue("Position"));
                        }
                        catch (ParseException e) {
                            this.markView = new PositionedView();
                        }
                    }
                    this.currentGroup.setView(this.markView);
                    if (this.currentGroup.parent == null) {
                        this.currentScope.addChild(this.currentGroup);
                    } else {
                        this.currentGroup.parent.addObject(this.currentGroup);
                    }
                    this.currentGroup = this.currentGroup.parent;
                    this.markView = null;
                    break block90;
                }
                if (localName.equals("OCCURRENCE")) {
                    this.object = new Object(this.occurrenceView, this.currentGroup, this.occurrenceBlendMode);
                    TicketState[] states = new TicketState[this.ticketStates.size()];
                    this.ticketStates.toArray(states);
                    if (this.occurrenceScope != null && this.occurrenceScope.equals("Global")) {
                        if (this.overwriteMode != null && this.overwriteMode.equals("Delete")) {
                            this.globalScope.removeOccurrence(this.occurrenceName, this.occurrenceEnvironment);
                        } else if (this.overwriteMode != null && this.overwriteMode.equals("Yes") || this.globalScope.findOccurrence(this.occurrenceName, this.occurrenceEnvironment) == null) {
                            this.globalScope.addOccurrence(this.occurrenceName, this.occurrenceEnvironment, this.occurrenceScope, new Occurrence(this.object, states));
                        }
                    } else {
                        this.currentScope.addOccurrence(this.occurrenceName, this.occurrenceEnvironment, this.occurrenceScope, new Occurrence(this.object, states));
                    }
                    this.occurrenceView = null;
                    this.object = null;
                    this.ticketStates.clear();
                    break block90;
                }
                if (localName.equals("OBJECT")) {
                    this.object = new Object(this.objectView, this.object);
                    int i = 0;
                    while (i < this.files.size()) {
                        this.object.addDependency((File)this.files.get(i));
                        ++i;
                    }
                    this.files.clear();
                    this.currentGroup.addObject(this.object);
                    this.objectView = null;
                    this.object = null;
                    break block90;
                }
                if (localName.equals("SUPPLIED_RESOURCE")) {
                    if (this.sourceChecksum != null) {
                        this.sourceChecksum.close();
                        if (this.sourceData != null) {
                            try {
                                this.sourceData.close();
                            }
                            catch (IOException e) {
                                throw new SAXException(e);
                            }
                        }
                        checksum = this.sourceChecksum.get();
                    } else {
                        checksum = this.sourceFile.getChecksum();
                    }
                    Resource resource = new Resource(this.sourceFormat, this.resourceInternalName, this.resourceType, this.resourceSubType, checksum, this.sourceFileName);
                    Scope parent = this.currentScope.getParent();
                    if (parent != null) {
                        parent.setDependencies(resource);
                    }
                    int i = 0;
                    while (i < this.files.size()) {
                        resource.addDependency((File)this.files.get(i));
                        ++i;
                    }
                    this.files.clear();
                    if (this.resourceScope != null && this.resourceScope.equals("Global")) {
                        if (this.overwriteMode != null && this.overwriteMode.equals("Delete")) {
                            this.globalScope.removeResource(this.resourceName, this.resourceEnvironment);
                        } else if (this.overwriteMode != null && this.overwriteMode.equals("Yes") || this.globalScope.findResource(this.resourceName, this.resourceEnvironment) == null) {
                            this.globalScope.addResource(resource, this.resourceName, this.resourceEnvironment, this.resourceScope);
                        }
                    } else {
                        this.currentScope.addResource(resource, this.resourceName, this.resourceEnvironment, this.resourceScope);
                    }
                    this.sourceFormat = null;
                    this.sourceIndex = -1;
                    this.sourceChecksum = null;
                    this.sourceFile = null;
                    this.sourceFileName = null;
                    this.resourceInternalName = null;
                    this.resourceType = null;
                    this.resourceSubType = null;
                    this.resourceScope = null;
                    break block90;
                }
                if (localName.equals("SUPPLIED_RESOURCE_REF")) break block90;
                if (localName.equals("SOURCE")) {
                    if (this.opacity != null) {
                        this.opacity = null;
                        this.error("Error not allowed to specify SOURCE and Opacity at the same time");
                    }
                    if (this.sourceChecksum != null) {
                        this.sourceChecksum.flush();
                        this.sourceChecksum.close();
                        if (this.sourceData != null) {
                            try {
                                this.sourceData.flush();
                                this.sourceData.close();
                            }
                            catch (IOException e) {
                                throw new SAXException(e);
                            }
                        }
                        checksum = this.sourceChecksum.get();
                    } else {
                        checksum = this.sourceFile != null ? this.sourceFile.getChecksum() : null;
                    }
                    java.awt.Rectangle clipRect = new java.awt.Rectangle();
                    clipRect.setRect(0.0, 0.0, this.sourceWidth, this.sourceHeight);
                    if (this.sourceClipRect != null) {
                        java.awt.Rectangle clipRect2 = new java.awt.Rectangle();
                        clipRect2.setRect(this.sourceClipRect[0], this.sourceClipRect[1], this.sourceClipRect[2] - this.sourceClipRect[0], this.sourceClipRect[3] - this.sourceClipRect[1]);
                        clipRect = clipRect.intersection(clipRect2);
                    }
                    this.object = new Object(this.objectLocation, this.sourceFormat, this.sourceIndex, this.sourceWidth, this.sourceHeight, new Area(clipRect), new AffineTransform(), checksum, this.sourceFileName, this.objectBlendMode, this.sourceTransparency);
                    this.object.blendColorSpace = this.currentGroup.blendColorSpace;
                    if (this.softmask != null) {
                        this.object.setSoftMask(this.softmask);
                        this.softmask = null;
                    }
                    this.currentScope.setDependencies(this.object);
                    if (this.sourceFormat.equals("application/postscript") && this.output != null && (this.inOutputRange() || this.reusableObjectView != null) && this.sourceIndex < 0) {
                        if (this.psFile == null) {
                            this.psFileName = this.allocateLocalFile("application/postscript");
                            this.psFile = new FileOutputStream(this.psFileName);
                            this.bufferedPSFile = new BufferedOutputStream(this.psFile, 32768);
                            this.distill = new OutputStreamWriter(this.bufferedPSFile);
                            this.distill.write("%!PS\n");
                            this.writeRunFile(this.distill, String.valueOf(ManifestGenerator.getInstallationPath()) + System.getProperty("file.separator") + "prolog.ps");
                            this.distill.flush();
                        }
                        this.writeRunObject(this.distill, this.object, this.object.getFileName(), false);
                        ++this.psIndex;
                        this.object.setPSIndex(this.psIndex);
                    }
                    this.sourceFormat = null;
                    this.sourceIndex = -1;
                    this.sourceChecksum = null;
                    this.sourceFile = null;
                    this.sourceFileName = null;
                    break block90;
                }
                if (localName.equals("REUSABLE_INTERNAL_DATA")) {
                    try {
                        if (this.XMLOutput != null) {
                            this.XMLOutput.close();
                            this.XMLOutput = null;
                        } else {
                            this.outputStream.close();
                        }
                        this.checksum.close();
                        if (this.sourceFile == null) {
                            this.sourceFile = new File(this.sourceFormat, null, this.checksum.get());
                        }
                    }
                    catch (IOException e) {
                        this.error("Error reading internal data: " + e.getMessage());
                    }
                    Resource resource = new Resource(this.sourceFormat, atts.getValue("Name"), "REUSABLE_INTERNAL_DATA", "", this.checksum.get(), this.sourceFileName);
                    int i = 0;
                    while (i < this.files.size()) {
                        resource.addDependency((File)this.files.get(i));
                        ++i;
                    }
                    this.files.clear();
                    this.internalDataScope.addResource(resource, atts.getValue("Name"), null, "PPML");
                    this.sourceFormat = null;
                    this.sourceIndex = -1;
                    this.sourceChecksum = null;
                    this.sourceFile = null;
                    this.sourceFileName = null;
                    this.outputStream = null;
                    break block90;
                }
                if (localName.equals("INTERNAL_DATA")) {
                    try {
                        if (this.XMLOutput != null) {
                            this.XMLOutput.close();
                            this.XMLOutput = null;
                        } else {
                            this.outputStream.close();
                        }
                        this.checksum.close();
                        if (this.sourceFile == null) {
                            this.sourceFile = new File(this.sourceFormat, null, this.checksum.get());
                        }
                    }
                    catch (IOException e) {
                        this.error("Error reading internal data: " + e.getMessage());
                    }
                    this.outputStream = null;
                    break block90;
                }
                if (localName.equals("SOFTMASK")) {
                    if (this.object != null) {
                        if (this.currentElement.equals("OBJECT")) {
                            this.softmask = this.object;
                        } else if (this.currentElement.equals("MARK")) {
                            this.currentGroup.setSoftMask(this.object);
                            this.softmask = null;
                        } else if (this.currentElement.equals("REUSABLE_OBJECT")) {
                            this.currentGroup.setSoftMask(this.object);
                            this.softmask = null;
                        } else {
                            this.error("Unknown context for SOFTMASK");
                        }
                        this.object = null;
                    }
                    this.opacity = null;
                } else if (!localName.equals("TICKET_REF")) {
                    if (localName.equals("TICKET_SET")) {
                        this.currentScope.addTicketSet(this.ticketSetID, this.currentTicketState);
                        this.currentTicketState = this.currentScope.getTicketState();
                    } else if (localName.equals("TICKET_STATE")) {
                        this.ticketStates.add(this.currentTicketState);
                        this.currentTicketState = this.currentScope.getTicketState();
                    } else if (localName.equals("TICKET")) {
                        this.ticketFile = this.sourceFile;
                    } else if (localName.equals("PRINT_LAYOUT")) {
                        this.currentImpositionTemplate = this.savedImpositionTemplate;
                    } else if (localName.equals("IMPOSITION")) {
                        if (this.currentImpositionTemplate == null) {
                            this.currentImpositionTemplate = this.impositionTemplate;
                        } else {
                            this.currentImpositionTemplate.merge(this.impositionTemplate);
                        }
                        this.impositionTemplate = null;
                    } else if (localName.equals("PRIVATE_INFO") && this.captureText) {
                        this.captureText = false;
                        this.currentScope.label = String.valueOf(this.currentScope.label) + " (" + this.text.replaceAll("^\\s+", "").replaceAll("\\s+$", "") + ")";
                    }
                }
            }
            catch (Exception e) {
                if (ManifestGenerator.debugMode) {
                    e.printStackTrace();
                }
                throw new SAXException(e);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.XMLOutput != null) {
            try {
                this.XMLOutput.writeText(ch, start, length);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.write(ch, start, length);
            }
            catch (IOException e) {
                this.error("Error reading internal data: " + e.getMessage());
            }
        }
        if (this.PPMLOutputStream != null) {
            try {
                this.PPMLOutputStream.writeText(ch, start, length);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (this.captureText) {
            this.text = String.valueOf(this.text) + new String(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
        this.error("Skipped entity " + name);
    }

    public void write(XMLWriter output) throws IOException {
        if (output != null) {
            this.ppmlScope.write(output);
        }
    }

    public Iterator getContentFiles() {
        return new TreeSet(this.contentFiles.values()).iterator();
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.warning("Warning: " + exception.getMessage());
    }

    public void error(SAXParseException exception) throws SAXException {
        this.error("Error: " + exception.getMessage());
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.error("Fatal: " + exception.getMessage());
    }

    private void writeRunResources(Writer distill, HashSet written, Iterator list) throws IOException {
        while (list.hasNext()) {
            Resource resource = (Resource)list.next();
            this.writeRunResources(distill, written, resource.getResourceDependencies());
            if (written.contains(resource)) continue;
            if (!resource.type.equals("ProcSet") || resource.subtype == null || !resource.subtype.equals("Prolog")) {
                this.writeRunResourceFile(distill, resource);
            } else {
                this.writeRunFile(distill, resource.getFileName());
            }
            written.add(resource);
        }
    }

    private void writeRunFile(Writer distill, String fileName) throws IOException {
        String absFileName = new java.io.File(fileName).getAbsolutePath();
        distill.write("(" + PDFContent.psPrefix + absFileName.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\)", "\\\\)").replaceAll("\\(", "\\\\(") + ") run\n");
    }

    private String PSString(String text) {
        return "(" + text.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\)", "\\\\)").replaceAll("\\(", "\\\\(") + ")";
    }

    private void writeRunResourceFile(Writer distill, Resource resource) throws IOException {
        String absFileName = new java.io.File(resource.getFileName()).getAbsolutePath();
        distill.write("//hiddenDict /setup get exec\n");
        distill.write("//hiddenDict /saveResources get exec\n");
        this.writeRunFile(distill, resource.getFileName());
        distill.write("/" + resource.getType() + " " + this.PSString(resource.getName()) + " //hiddenDict /keepResource get exec\n");
        distill.write("//hiddenDict /restoreResources get exec\n");
        distill.write("//hiddenDict /cleanup get exec\n");
    }

    private void writeRunContentFile(Writer distill, String fileName) throws IOException {
        String absFileName = new java.io.File(fileName).getAbsolutePath();
        distill.write("//hiddenDict /setup get exec\n");
        distill.write("(" + PDFContent.psPrefix + absFileName.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\)", "\\\\)").replaceAll("\\(", "\\\\(") + ") //hiddenDict /runEPS get exec\n");
        distill.write("//hiddenDict /cleanup get exec\n");
    }

    private void writeRunObject(Writer distill, Object object, String fileName, boolean multiPage) throws IOException {
        HashSet written = new HashSet();
        distill.write("(%%[CHECKPPML:" + object.getLocation() + "]\\n) print");
        distill.write("{\n");
        this.writeRunResources(distill, written, object.getResourceDependencies());
        this.writeRunContentFile(distill, fileName);
        distill.write("}\n");
        distill.write(String.valueOf(multiPage) + "\n");
        distill.write("<< /PageSize [" + object.getWidth() + " " + object.getHeight() + "] >>\n");
        if (ManifestGenerator.checkEPS) {
            distill.write("hiddenDict /createPageChecked get exec\n");
        } else {
            distill.write("hiddenDict /createPage get exec\n");
        }
    }

    private File useExternalSrc(String src, boolean mayConcatenate) throws IOException {
        MD5Checksum checksum;
        OutputStream output;
        InputStream input;
        URL url;
        try {
            url = new URL(this.baseDir, src);
        }
        catch (MalformedURLException e) {
            throw new IOException("Invalid url " + src);
        }
        File result = null;
        String localFileName = null;
        result = (File)this.fileInfoCache.get(url.toString());
        if (result != null && this.sourceFile == null) {
            this.sourceFile = result;
            this.sourceFileName = result.getLocalCopy();
            return result;
        }
        if (result != null) {
            localFileName = result.getLocalCopy();
        } else if (url.getProtocol().equals("file")) {
            localFileName = url.getPath();
        }
        if (this.sourceFile != null && this.sourceChecksum == null) {
            this.setupSourceConcatenation();
        }
        if (localFileName != null) {
            input = new BufferedInputStream(new FileInputStream(localFileName), 32768);
            output = this.sourceChecksum;
        } else {
            input = url.openStream();
            localFileName = this.allocateLocalFile(this.sourceFormat);
            output = new StreamCopy((OutputStream)this.sourceChecksum, localFileName);
        }
        try {
            checksum = new MD5Checksum(output);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Can't load MD5 checksum class");
        }
        checksum.copy(input);
        checksum.close();
        if (result == null) {
            result = new File(this.sourceFormat, src, checksum.get());
            this.fileInfoCache.put(url.toString(), result);
        }
        result.setLocalCopy(localFileName);
        if (this.sourceFile == null) {
            this.sourceFileName = localFileName;
        }
        this.sourceFile = result;
        return result;
    }

    private String allocateLocalFile(String sourceFormat) throws IOException {
        String suffix;
        DecimalFormat format = new DecimalFormat("#0000");
        String fileName = "src" + format.format(this.objectNr++);
        if (sourceFormat.equals("application/postscript")) {
            suffix = ".ps";
        } else if (sourceFormat.equals("application/pdf")) {
            suffix = ".pdf";
        } else if (sourceFormat.equals("image/tiff")) {
            suffix = ".tif";
        } else if (sourceFormat.equals("image/jpeg")) {
            suffix = ".jpg";
        } else {
            throw new IOException(String.valueOf(sourceFormat) + " is not supported");
        }
        java.io.File localFile = new java.io.File(this.fileDir, String.valueOf(fileName) + suffix);
        ManifestGenerator.deleteWhenDone(localFile);
        return localFile.getAbsolutePath();
    }

    private void setupSourceConcatenation() throws IOException {
        if (this.fileDir != null) {
            this.sourceFileName = this.allocateLocalFile(this.sourceFormat);
            try {
                this.sourceData = new BufferedOutputStream(new FileOutputStream(this.sourceFileName), 32768);
            }
            catch (IOException e) {
                throw new IOException("Can't create source file " + this.sourceFileName);
            }
        } else {
            this.sourceData = null;
        }
        try {
            this.sourceChecksum = new MD5Checksum(this.sourceData);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Can't load MD5 checksum class");
        }
        if (this.sourceFile != null) {
            this.sourceChecksum.copy(new BufferedInputStream(new FileInputStream(this.sourceFile.getLocalCopy()), 32768));
        }
    }

    private void generatePDF() throws IOException {
        this.currentPageNr = 0;
        int jobs = this.ppmlScope.getNrOfChildren();
        this.output.startOutline("PPML: " + this.ppmlScope.label);
        int jobNr = 0;
        while (jobNr < jobs) {
            Scope jobScope = (Scope)this.ppmlScope.getChild(jobNr);
            this.output.startOutline("Job: " + jobScope.label);
            int documents = jobScope.getNrOfChildren();
            int docNr = 0;
            while (docNr < documents) {
                Scope docScope = (Scope)jobScope.getChild(docNr);
                int docCopies = docScope.getCopies();
                int pages = docScope.getNrOfChildren();
                int copyNr = 0;
                while (copyNr < docCopies) {
                    if (docCopies > 1) {
                        this.output.startOutline("Document: " + docScope.label + " #" + (copyNr + 1));
                    } else {
                        this.output.startOutline("Document: " + docScope.label);
                    }
                    int pageNr = 0;
                    while (pageNr < pages) {
                        ++this.currentPageNr;
                        if (this.inOutputRange()) {
                            if (ManifestGenerator.debugMode) {
                                System.err.println("Processing page " + this.currentPageNr);
                            }
                            PageScope pageScope = (PageScope)docScope.getChild(pageNr);
                            this.output.startOutline("Page: " + pageScope.label);
                            double[] trimBox = pageScope.getTrimBox();
                            this.output.startPage((float)trimBox[0], (float)trimBox[1], (float)trimBox[2], (float)trimBox[3]);
                            PDFOutput groupOutput = this.output;
                            groupOutput = this.output.createGroup(true, pageScope.getKnockout(), pageScope.getBlendColorSpace(), new Rectangle((float)trimBox[0], (float)trimBox[1], (float)trimBox[2], (float)trimBox[3]));
                            int objectCount = pageScope.getNrOfChildren();
                            int objectNr = 0;
                            while (objectNr < objectCount) {
                                if (!ManifestGenerator.skipMode || objectNr != 0 && objectNr != objectCount - 1) {
                                    Object object = (Object)pageScope.getChild(objectNr);
                                    if (object.isGroup()) {
                                        this.placeGroup(groupOutput, object);
                                    } else {
                                        this.placeObject(groupOutput, object);
                                    }
                                }
                                ++objectNr;
                            }
                            if (this.isTestCase) {
                                groupOutput.addWaterMark("CHECKPPML");
                            } else if (objectCount == 0) {
                                this.output.makeEmptyPage();
                            }
                            groupOutput.endGroup();
                            this.output.endOutline();
                        }
                        ++pageNr;
                    }
                    this.output.endOutline();
                    ++copyNr;
                }
                ++docNr;
            }
            this.output.endOutline();
            ++jobNr;
        }
        this.output.endOutline();
    }

    public void placeGroup(PDFOutput output, Object group) throws IOException {
        output.save();
        output.setupTransform(AffineTransform.getTranslateInstance(group.getX(), group.getY()));
        output.setBlendMode(group.getBlendMode(), this.getOpacity(group), this.getSoftMask(output, group));
        output.setupClip(group.getClipPath());
        PDFOutput groupOutput = output;
        groupOutput = output.createGroup(group.isIsolated(), group.isKnockout(), group.getBlendColorSpace(), group.getBBox());
        groupOutput.setupTransform(group.getTransform());
        Iterator i = group.getObjects();
        while (i.hasNext()) {
            Object object = (Object)i.next();
            if (object.isRef()) {
                this.placeObject(groupOutput, object);
                continue;
            }
            if (object.isGroup()) {
                this.placeGroup(groupOutput, object);
                continue;
            }
            this.placeObject(groupOutput, object);
        }
        groupOutput.endGroup();
        output.restore();
    }

    public void placeObject(PDFOutput output, Object object) throws IOException {
        Content content = this.getContent(output, object);
        if (content != null) {
            output.save();
            output.setupTransform(AffineTransform.getTranslateInstance(object.getX(), object.getY()));
            output.setBlendMode(object.getBlendMode(), this.getOpacity(object), this.getSoftMask(output, object));
            if (object.isGroup()) {
                output.place(new AffineTransform(), object.getClipPath(), content);
            } else {
                output.place(object.getTransform(), object.getClipPath(), content);
            }
            output.restore();
        }
    }

    private PdfTemplate getSoftMask(PDFOutput output, Object object) throws IOException {
        Object softmask = object.getSoftMask();
        PdfTemplate maskdata = null;
        if (softmask != null && softmask.getOpacity() < 0.0) {
            Content content = this.getContent(output, softmask);
            maskdata = content.getReusableContent(output, object.getBlendColorSpace());
        }
        return maskdata;
    }

    private double getOpacity(Object object) {
        Object softmask = object.getSoftMask();
        if (softmask == null) {
            return -1.0;
        }
        return softmask.getOpacity();
    }

    private Content getContent(PDFOutput output, Object object) throws IOException {
        String format = object.getFormat();
        int index = object.getIndex();
        String key = object.getFileName();
        Content content = null;
        Object cached = null;
        if (key == null && !object.isRef()) {
            return null;
        }
        if (object.getPSIndex() >= 0) {
            key = this.psFileName;
            index = object.getPSIndex();
        }
        if (object.isRef()) {
            key = "[name:" + object.cacheName() + "]";
            index = -1;
        } else {
            key = "[file:" + key + "]";
        }
        cached = (Object)this.objectCache.get(String.valueOf(key) + index);
        if (cached != null && object.hasCompatibleContext(cached)) {
            content = (Content)this.contentCache.get(String.valueOf(key) + index);
            if (!(content.hasDimensions() || object.getWidth() == cached.getWidth() && object.getHeight() == cached.getHeight())) {
                cached = null;
            }
        } else {
            cached = (Object)this.objectCache.get(key);
            if (cached != null && object.hasCompatibleContext(cached)) {
                content = (Content)this.contentCache.get(key);
                content = content.create(index, (float)object.getWidth(), (float)object.getHeight(), object.getBlendColorSpace());
            } else {
                cached = null;
            }
        }
        if (cached == null) {
            if (object.isGroup()) {
                content = new CompoundContent(output, object, this);
            } else if (format.equals("application/postscript")) {
                if (object.getPSIndex() < 0) {
                    String fileName = this.allocateLocalFile("application/postscript");
                    FileOutputStream physicalFile = new FileOutputStream(fileName);
                    BufferedOutputStream bufferedFile = new BufferedOutputStream(physicalFile, 32768);
                    OutputStreamWriter distill = new OutputStreamWriter(bufferedFile);
                    distill.write("%!PS\n");
                    this.writeRunFile(distill, String.valueOf(ManifestGenerator.getInstallationPath()) + System.getProperty("file.separator") + "prolog.ps");
                    this.writeRunObject(distill, object, object.getFileName(), true);
                    ((Writer)distill).flush();
                    ((Writer)distill).close();
                    ((OutputStream)bufferedFile).close();
                    ((OutputStream)physicalFile).close();
                    content = PDFContent.PSToPDF(output, fileName, index, object.getBlendColorSpace());
                } else {
                    content = new PDFContent(output, String.valueOf(this.psFileName) + ".pdf", index, false, object.getBlendColorSpace());
                    this.objectCache.put(key, object);
                    this.contentCache.put(key, content);
                    content.getReusableContent(output, object.getBlendColorSpace());
                }
            } else if (format.equals("application/pdf")) {
                PDFContent pdfContent = new PDFContent(output, object.getFileName(), index, object.getBlendColorSpace());
                String version = pdfContent.getVersion();
                content = pdfContent;
                if (ManifestGenerator.debugMode) {
                    System.err.println(String.valueOf(object.getFileName()) + ":" + version + " " + object.getTransparency());
                }
                if (this.ppmlVersion.compareTo("3.0") >= 0) {
                    if (version.compareTo("1.6") > 0) {
                        if (this.isGA) {
                            this.error(object.getLocation(), "PDF " + version + " content is not allowed in PPML/GA");
                        } else {
                            this.warning(object.getLocation(), "COMPATIBILITY: PDF " + version + " content is disallowed in PPML/GA");
                        }
                    }
                    if (version.compareTo("1.3") > 0 && !"Isolated".equals(object.getTransparency())) {
                        if (ManifestGenerator.isMac) {
                            this.warning(object.getLocation(), "CheckPPML currently does not implement transparency flattening for PDF on a Mac");
                        }
                        if (PDFContent.psConverter.compareTo("distiller") != 0) {
                            this.warning(object.getLocation(), "CheckPPML currently does not implement transparency flattening for PDF when using GhostScript");
                        } else {
                            String flattenedFileName = PDFContent.PDFToPS(object.getFileName());
                            content = PDFContent.PSToPDF(output, flattenedFileName, index, object.getBlendColorSpace());
                        }
                    }
                } else if (version.compareTo("1.3") > 0) {
                    if (this.isGA) {
                        this.error(object.getLocation(), "PDF " + version + " content is not allowed in PPML/GA");
                    } else {
                        this.warning(object.getLocation(), "COMPATIBILITY: PDF " + version + " content is disallowed in PPML/GA");
                    }
                }
            } else if (format.equals("image/tiff") || format.equals("image/jpeg")) {
                content = new ImageContent(object.getFileName(), format, index, (float)object.getWidth(), (float)object.getHeight(), object.getBlendColorSpace());
            }
        }
        if (content != null) {
            if (!object.isGroup() && content.hasDimensions() && (Math.abs((double)content.getWidth() - object.getWidth()) > 0.5 || Math.abs((double)content.getHeight() - object.getHeight()) > 0.5)) {
                if (this.isGA) {
                    this.error(object.getLocation(), "The dimensions of the object " + object.getWidth() + "x" + object.getHeight() + " do not match those of the content " + content.getWidth() + "x" + content.getHeight());
                } else {
                    this.warning(object.getLocation(), "COMPATIBILITY: The dimensions of the object " + object.getWidth() + "x" + object.getHeight() + " do not match those of the content " + content.getWidth() + "x" + content.getHeight());
                }
            }
            if (object.getIndex() > 0 || object.getName() != null) {
                this.objectCache.put(key, object);
                this.objectCache.put(String.valueOf(key) + index, object);
                this.contentCache.put(key, content);
                this.contentCache.put(String.valueOf(key) + index, content);
                content.getReusableContent(output, object.getBlendColorSpace());
            }
        }
        return content;
    }

    private void addStaticResource(OutputStream output, String name) throws IOException {
        int count;
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(name);
        if (input == null) {
            throw new IOException("Can't locate support file `" + name + "'");
        }
        byte[] buffer = new byte[512];
        while ((count = input.read(buffer)) > 0) {
            output.write(buffer, 0, count);
        }
        input.close();
    }

    public Scope getPage(int setNr, int docNr, int pageNr) {
        if (setNr > this.ppmlScope.getNrOfChildren() || setNr < 1) {
            return null;
        }
        Scope scope = (Scope)this.ppmlScope.getChild(setNr - 1);
        if (docNr > scope.getNrOfChildren() || docNr < 1) {
            return null;
        }
        if (pageNr > (scope = (Scope)scope.getChild(docNr - 1)).getNrOfChildren() || pageNr < 1) {
            return null;
        }
        return (Scope)scope.getChild(pageNr - 1);
    }

    public int getPageCount(int setNr, int docNr) {
        if (setNr > this.ppmlScope.getNrOfChildren() || setNr < 1) {
            return 0;
        }
        Scope scope = (Scope)this.ppmlScope.getChild(setNr - 1);
        if (docNr > scope.getNrOfChildren() || docNr < 1) {
            return 0;
        }
        scope = (Scope)scope.getChild(docNr - 1);
        return scope.getNrOfChildren();
    }

    public int getDocCount(int setNr) {
        if (setNr > this.ppmlScope.getNrOfChildren() || setNr < 1) {
            return 0;
        }
        Scope scope = (Scope)this.ppmlScope.getChild(setNr - 1);
        return scope.getNrOfChildren();
    }

    public int geSetCount(int setNr) {
        return this.ppmlScope.getNrOfChildren();
    }
}

