/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import net.caslon.checkPPML.ParseException;

class PositionedView {
    double x;
    double y;
    AffineTransform transform = null;
    Rectangle clipRect = null;

    public PositionedView() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public PositionedView(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public PositionedView(String position) throws ParseException {
        if (position == null || !position.matches("[+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)?")) {
            this.x = 0.0;
            this.y = 0.0;
            throw new ParseException("Illegal Position " + position + " specified");
        }
        String[] numbers = position.split(" ");
        this.x = Double.parseDouble(numbers[0]);
        this.y = Double.parseDouble(numbers[1]);
    }

    public void setClipRect(String rect) throws ParseException {
        double ury;
        double urx;
        double lly;
        double llx;
        if (rect != null && rect.matches("[+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)?")) {
            String[] numbers = rect.split(" ");
            this.clipRect = new Rectangle();
            llx = Double.parseDouble(numbers[0]);
            lly = Double.parseDouble(numbers[1]);
            urx = Double.parseDouble(numbers[2]);
            ury = Double.parseDouble(numbers[3]);
            if (urx < llx || ury < lly) {
                this.clipRect = null;
                throw new ParseException("Illegal/empty ClipRect " + rect + " specified");
            }
        } else {
            this.clipRect = null;
            throw new ParseException("Illegal ClipRect " + rect + " specified");
        }
        this.clipRect.setRect(llx, lly, urx - llx, ury - lly);
    }

    public void setTransform(String matrix) throws ParseException {
        if (matrix == null || !matrix.matches("[+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)? [+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))(?:[eE][+-]?[0-9]+)?")) {
            this.transform = null;
            throw new ParseException("Illegal Matrix " + matrix + " specified");
        }
        String[] numbers = matrix.split(" ");
        double m00 = Double.parseDouble(numbers[0]);
        double m10 = Double.parseDouble(numbers[1]);
        double m01 = Double.parseDouble(numbers[2]);
        double m11 = Double.parseDouble(numbers[3]);
        double m02 = Double.parseDouble(numbers[4]);
        double m12 = Double.parseDouble(numbers[5]);
        this.transform = new AffineTransform(m00, m10, m01, m11, m02, m12);
    }

    public Rectangle getClipRect() {
        return this.clipRect;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }
}

