/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import net.caslon.checkPPML.File;
import net.caslon.checkPPML.XMLSerialisable;
import net.caslon.checkPPML.XMLWriter;

public class Resource
implements XMLSerialisable {
    Vector files;
    Vector resources;
    String format;
    String name;
    String type;
    String subtype;
    String checksum;
    String fileName;

    public Resource(String format, String name, String type, String subtype, String checksum, String fileName) {
        this.format = format;
        this.name = name;
        this.type = type;
        this.subtype = subtype;
        this.checksum = checksum;
        this.fileName = fileName;
        this.files = new Vector();
        this.resources = new Vector();
    }

    public void addDependency(File file) {
        this.files.add(file);
    }

    public void addDependency(Resource resource) {
        this.resources.add(resource);
    }

    public Iterator getResourceDependencies() {
        return this.resources.iterator();
    }

    public void write(XMLWriter stream) throws IOException {
        stream.startElement("RESOURCE");
        stream.writeAttribute("Format", this.format);
        stream.writeAttribute("Name", this.name);
        stream.writeAttribute("Type", this.type);
        if (this.subtype != null) {
            stream.writeAttribute("SubType", this.subtype);
        }
        stream.writeAttribute("Checksum", this.checksum);
        int nrOfFiles = this.files.size();
        int i = 0;
        while (i < nrOfFiles) {
            XMLSerialisable dependency = (XMLSerialisable)this.files.get(i);
            dependency.write(stream);
            ++i;
        }
        int nrOfResources = this.resources.size();
        int i2 = 0;
        while (i2 < nrOfResources) {
            XMLSerialisable dependency = (XMLSerialisable)this.resources.get(i2);
            dependency.write(stream);
            ++i2;
        }
        stream.endElement("RESOURCE");
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }
}

