/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.caslon.checkPPML.Object;
import net.caslon.checkPPML.Occurrence;
import net.caslon.checkPPML.Resource;
import net.caslon.checkPPML.TicketState;
import net.caslon.checkPPML.XMLSerialisable;
import net.caslon.checkPPML.XMLWriter;

public class Scope
implements XMLSerialisable {
    String level;
    String scope;
    String label;
    Scope parent;
    Vector children;
    Map objects;
    Map resources;
    Vector requiredResources;
    TicketState ticketState;
    Map ticketSets;
    int copies;
    double[] trimBox;
    double[] bleedBox;

    public Scope(Scope parent, String level, String scope, String label) {
        this.parent = parent;
        this.level = level;
        this.label = label;
        this.scope = scope;
        this.children = new Vector();
        this.objects = new HashMap();
        this.resources = new HashMap();
        if (parent != null) {
            parent.addChild(this);
        }
        this.requiredResources = new Vector();
        this.ticketState = parent != null ? new TicketState(parent.ticketState) : new TicketState();
        this.ticketSets = new HashMap();
        this.copies = 1;
        this.trimBox = null;
        this.bleedBox = null;
        if (this.label == null) {
            this.label = parent != null ? String.valueOf(parent.children.size()) : "";
        }
    }

    public double[] getTrimBox() {
        if (this.trimBox == null && this.parent != null) {
            return this.parent.getTrimBox();
        }
        return this.trimBox;
    }

    public double[] getBleedBox() {
        if (this.bleedBox == null && this.parent != null) {
            return this.parent.getBleedBox();
        }
        return this.bleedBox;
    }

    public void setTrimBox(double[] trimBox) {
        this.trimBox = trimBox;
    }

    public void setBleedBox(double[] bleedBox) {
        this.bleedBox = bleedBox;
    }

    public void setCopies(int count) {
        this.copies = count;
    }

    public int getCopies() {
        return this.copies;
    }

    public int getNrOfChildren() {
        return this.children.size();
    }

    public XMLSerialisable getChild(int i) {
        return (XMLSerialisable)this.children.get(i);
    }

    public TicketState getTicketState() {
        return this.ticketState;
    }

    public Scope getParent() {
        return this.parent;
    }

    void addChild(XMLSerialisable child) {
        this.children.add(child);
    }

    public void addOccurrence(String name, String environment, String scope, Occurrence occurrence) {
        if (this.scope.equals(scope) || scope == null) {
            if (this.objects.get(name) != null) {
                throw new RuntimeException("Redefinition of " + name + " in scope " + this.scope + " specified");
            }
            this.objects.put(name, occurrence);
        } else if (this.parent != null) {
            this.parent.addOccurrence(name, environment, scope, occurrence);
        } else {
            throw new RuntimeException("Unknown scope " + scope + " specified");
        }
    }

    public Occurrence findOccurrence(String name, String environment) {
        Occurrence result = (Occurrence)this.objects.get(name);
        if (result != null && environment == null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.findOccurrence(name, environment);
        }
        return null;
    }

    public void requireResource(Resource resource) {
        String key = String.valueOf(resource.getType()) + ":" + resource.getName();
        if (this.resources.get(key) != null) {
            throw new RuntimeException(String.valueOf(resource.getType()) + " " + resource.getName() + " already defined in scope " + this.scope);
        }
        this.resources.put(key, resource);
        this.requiredResources.add(resource);
    }

    private void setDependencies(Object object, Map defined) {
        String key;
        Resource required;
        int i = 0;
        while (i < this.requiredResources.size()) {
            required = (Resource)this.requiredResources.get(i);
            key = String.valueOf(required.getType()) + ":" + required.getName();
            if (defined.get(key) == null) {
                defined.put(key, required);
            }
            ++i;
        }
        if (this.parent != null) {
            this.parent.setDependencies(object, defined);
        }
        i = 0;
        while (i < this.requiredResources.size()) {
            required = (Resource)this.requiredResources.get(i);
            key = String.valueOf(required.getType()) + ":" + required.getName();
            if (defined.get(key) == required) {
                object.addDependency(required);
            }
            ++i;
        }
    }

    public void setDependencies(Object object) {
        this.setDependencies(object, new HashMap());
    }

    private void setDependencies(Resource resource, Map defined) {
        String key;
        Resource required;
        int i = 0;
        while (i < this.requiredResources.size()) {
            required = (Resource)this.requiredResources.get(i);
            key = String.valueOf(required.getType()) + ":" + required.getName();
            if (defined.get(key) == null) {
                defined.put(key, required);
            }
            ++i;
        }
        if (this.parent != null) {
            this.parent.setDependencies(resource, defined);
        }
        i = 0;
        while (i < this.requiredResources.size()) {
            required = (Resource)this.requiredResources.get(i);
            key = String.valueOf(required.getType()) + ":" + required.getName();
            if (defined.get(key) == required) {
                resource.addDependency(required);
            }
            ++i;
        }
    }

    public void setDependencies(Resource resource) {
        this.setDependencies(resource, new HashMap());
    }

    public void addResource(Resource resource, String name, String environment, String scope) {
        if (scope == null || scope.equals(this.scope)) {
            if (this.resources.get(name) != null) {
                throw new RuntimeException("Redefinition of resource " + resource.getName() + " in scope " + this.scope + " specified");
            }
            this.resources.put(name, resource);
        } else if (this.parent != null) {
            this.parent.addResource(resource, name, environment, scope);
        } else {
            throw new RuntimeException("Unknown scope " + scope + " specified for resource " + name);
        }
    }

    public Resource findResource(String name, String environment) {
        Resource result = (Resource)this.resources.get(name);
        if (result != null && environment == null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.findResource(name, environment);
        }
        return null;
    }

    public void write(XMLWriter stream) throws IOException {
        stream.startElement(this.level);
        if (this.label != null) {
            stream.writeAttribute("Label", this.label);
        }
        this.writeAttributes(stream);
        this.writeChildren(stream);
        stream.endElement(this.level);
    }

    protected void writeAttributes(XMLWriter stream) throws IOException {
    }

    protected void writeChildren(XMLWriter stream) throws IOException {
        int i = 0;
        while (i < this.children.size()) {
            XMLSerialisable child = (XMLSerialisable)this.children.get(i);
            child.write(stream);
            ++i;
        }
    }

    public TicketState findTicketSet(String name) {
        TicketState result = (TicketState)this.ticketSets.get(name);
        if (result != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.findTicketSet(name);
        }
        return null;
    }

    public void addTicketSet(String name, TicketState state) {
        if (this.ticketSets.get(name) != null) {
            throw new RuntimeException("Ticket set with name " + name + " already defined in scope " + this.scope);
        }
        this.ticketSets.put(name, state);
    }
}

