/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamCopy
extends OutputStream {
    OutputStream output;
    OutputStream copy;
    OutputStream file;

    public StreamCopy(OutputStream dst, String fileName) throws IOException {
        this.output = dst;
        this.file = new FileOutputStream(fileName);
        this.copy = new BufferedOutputStream(this.file, 32768);
    }

    public StreamCopy(OutputStream dst, OutputStream copy) throws IOException {
        this.output = dst;
        this.copy = copy;
    }

    public void close() throws IOException {
        this.output = null;
        this.copy.flush();
        this.copy.close();
        this.file.flush();
        this.file.close();
    }

    public void flush() throws IOException {
        if (this.output != null) {
            this.output.flush();
        }
        this.copy.flush();
        this.file.flush();
    }

    public void write(int b) throws IOException {
        if (this.output != null) {
            this.output.write(b);
        }
        this.copy.write(b);
    }

    public void write(byte[] b) throws IOException {
        if (this.output != null) {
            this.output.write(b);
        }
        this.copy.write(b);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        if (this.output != null) {
            this.output.write(b, offset, length);
        }
        this.copy.write(b, offset, length);
    }

    public void write(byte b) throws IOException {
        if (this.output != null) {
            this.output.write(b);
        }
        this.copy.write(b);
    }

    public void copy(InputStream input) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[512];
        while ((bytesRead = input.read(buffer)) >= 0) {
            this.write(buffer, 0, bytesRead);
        }
    }
}

