/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VDXInput
extends PdfReader {
    Logger logger = Logger.getLogger("Parser");
    static final PdfName VDX_KEY = new PdfName("PPMLVDXData");
    static final PdfName CGATS_VDX_KEY = new PdfName("GTS_PPMLVDXData");
    static final String VERSION_KEY = "GTS_PPMLVDXVersion";
    static final String CONFORMANCE_KEY = "GTS_PPMLVDXConformance";
    static final String PDFX_VERSION_KEY = "GTS_PDFXVersion";
    boolean isCGATS;

    public VDXInput(String filename) throws IOException {
        super(filename);
        HashMap keys = this.getInfo();
        String version = (String)keys.get(VERSION_KEY);
        String conformance = (String)keys.get(CONFORMANCE_KEY);
        if (version == null || conformance == null) {
            throw new IOException("file is not a conforming PPML/VDX-Strict file");
        }
        this.isCGATS = true;
        if (version.equals("PPML/VDX:2002")) {
            if (!conformance.equals("PPML/VDX-Strict:2002")) {
                this.logger.log(Level.WARNING, String.valueOf(filename) + ": file is not a conforming PPML/VDX-Strict:2002 file");
            }
        } else if (version.equals("PPML/VDX:2001")) {
            if (!conformance.equals("PPML/VDX-Strict:2001")) {
                this.logger.log(Level.WARNING, String.valueOf(filename) + ": file is not a conforming PPML/VDX-Strict:2001 file");
            }
        } else if (version.equals("PPMLVDX:2001")) {
            if (!conformance.equals("PPMLVDX2:2001")) {
                this.logger.log(Level.WARNING, String.valueOf(filename) + ": file is not a conforming PPML/VDX-Strict file");
            }
            this.isCGATS = false;
        } else {
            this.logger.log(Level.WARNING, String.valueOf(filename) + ": file is not a conforming PPML/VDX-Strict file");
        }
        if (this.isCGATS) {
            String pdfxVersion = (String)keys.get(PDFX_VERSION_KEY);
            if (pdfxVersion == null) {
                this.logger.log(Level.WARNING, String.valueOf(filename) + ": file is not a conforming PDF/X file");
            } else if (!pdfxVersion.equals("PDF/X-3:2001") && !pdfxVersion.equals("PDF/X-1a:2003")) {
                this.logger.log(Level.WARNING, String.valueOf(filename) + ": file is not a conforming PDF/X-1a or PDF/X-3 file");
            }
        }
    }

    public InputStream getPPMLStream() throws IOException {
        PdfObject object = this.getCatalog().get(this.isCGATS ? CGATS_VDX_KEY : VDX_KEY);
        if (object != null && object.isIndirect()) {
            object = object.getDirectObject();
        }
        if (object == null || !object.isStream()) {
            throw new IOException("file does not contain the VDX key");
        }
        byte[] data = PdfReader.getStreamBytes((PRStream)object);
        return new ByteArrayInputStream(data);
    }
}

