/*
 * Decompiled with CFR 0.152.
 */
package net.caslon.checkPPML;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;

public class XMLWriter {
    int indent;
    boolean inTag;
    boolean inText;
    PrintWriter stream;
    String elementName;
    HashMap prefixes;

    public XMLWriter(PrintWriter stream) {
        if (stream == null) {
            throw new RuntimeException("Can't write to null streams");
        }
        this.stream = stream;
        this.indent = 0;
        this.inTag = false;
        this.inText = false;
        this.prefixes = new HashMap();
        stream.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
    }

    void writeIndent(int level) throws IOException {
        int i = 0;
        while (i < level) {
            this.stream.print(" ");
            ++i;
        }
    }

    public void addPrefix(String prefix, String uri) {
        this.prefixes.put(prefix, uri);
    }

    public void writeText(String value) throws IOException {
        if (value == null) {
            return;
        }
        if (this.inTag) {
            this.stream.print(">");
            this.inTag = false;
        }
        this.inText = true;
        this.stream.print(value.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;"));
    }

    public void writeText(char[] value, int start, int length) throws IOException {
        if (value == null) {
            return;
        }
        if (this.inTag) {
            this.stream.print(">");
            this.inTag = false;
        }
        this.inText = true;
        int pos = start;
        int i = 0;
        while (i < length) {
            switch (value[start + i]) {
                case '<': {
                    this.stream.write(value, pos, start + i - pos);
                    this.stream.print("&lt;");
                    pos = start + i + 1;
                    break;
                }
                case '>': {
                    this.stream.write(value, pos, start + i - pos);
                    this.stream.print("&gt;");
                    pos = start + i + 1;
                    break;
                }
                case '&': {
                    this.stream.write(value, pos, start + i - pos);
                    this.stream.print("&amp;");
                    pos = start + i + 1;
                }
            }
            ++i;
        }
        this.stream.write(value, pos, start + length - pos);
    }

    public void startElement(String name) throws IOException {
        if (this.inTag) {
            this.stream.println(">");
            this.inTag = false;
        }
        if (!this.inText) {
            this.writeIndent(this.indent);
        }
        this.inText = false;
        this.inTag = true;
        this.stream.print("<");
        this.stream.print(name);
        this.indent += 2;
        for (String prefix : this.prefixes.keySet()) {
            String uri = (String)this.prefixes.get(prefix);
            if (prefix != null && prefix.length() > 0) {
                this.writeAttribute("xmlns:" + prefix, uri);
                continue;
            }
            this.writeAttribute("xmlns", uri);
        }
        this.prefixes.clear();
    }

    public void endElement(String name) throws IOException {
        this.indent -= 2;
        if (this.inTag) {
            this.stream.println("/>");
        } else {
            if (!this.inText) {
                this.writeIndent(this.indent);
            }
            this.stream.print("</");
            this.stream.print(name);
            this.stream.println(">");
        }
        this.inTag = false;
        this.inText = false;
    }

    public void writeAttribute(String name, String value) throws IOException {
        if (!this.inTag) {
            throw new IOException("Can't write attribute " + name + " as we are not in a tag");
        }
        this.stream.print(" ");
        this.stream.print(name);
        this.stream.print("=\"");
        this.stream.print(value.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("\"", "&quot;"));
        this.stream.print("\"");
    }

    public void close() throws IOException {
        this.stream.flush();
        this.stream.close();
    }
}

