/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOMetadata;

public class TIFFT4Compressor
extends TIFFFaxCompressor {
    private boolean is1DMode = false;
    private boolean isEOLAligned = false;

    public TIFFT4Compressor() {
        super("CCITT T.4", 3, true);
    }

    public void setMetadata(IIOMetadata iIOMetadata) {
        super.setMetadata(iIOMetadata);
        if (iIOMetadata instanceof TIFFImageMetadata) {
            TIFFImageMetadata tIFFImageMetadata = (TIFFImageMetadata)iIOMetadata;
            TIFFField tIFFField = tIFFImageMetadata.getTIFFField(292);
            if (tIFFField != null) {
                int n = tIFFField.getAsInt(0);
                this.is1DMode = (n & 1) == 0;
                this.isEOLAligned = (n & 4) == 4;
            } else {
                long[] lArray = new long[]{(this.isEOLAligned ? 4 : 0) | (this.is1DMode ? 0 : 1)};
                BaselineTIFFTagSet baselineTIFFTagSet = BaselineTIFFTagSet.getInstance();
                TIFFField tIFFField2 = new TIFFField(baselineTIFFTagSet.getTag(292), 4, 1, lArray);
                tIFFImageMetadata.rootIFD.addTIFFField(tIFFField2);
            }
        }
    }

    public int encodeT4(boolean bl, boolean bl2, byte[] byArray, int n, int n2, int n3, int n4, byte[] byArray2) {
        int n5;
        byte[] byArray3 = byArray;
        int n6 = 0;
        int n7 = 0;
        this.initBitBuf();
        int n8 = 2;
        for (n5 = 0; n5 < n4; ++n5) {
            if (bl || n5 % n8 == 0) {
                n7 += this.addEOL(bl, bl2, true, byArray2, n7);
                n7 += this.encode1D(byArray, n6, n2, n3, byArray2, n7);
            } else {
                n7 += this.addEOL(bl, bl2, false, byArray2, n7);
                int n9 = n6 - n;
                int n10 = n2;
                int n11 = n10 + n3;
                int n12 = (byArray[n6 + (n10 >>> 3)] & 0xFF) >>> 7 - (n10 & 7) & 1;
                int n13 = n12 != 0 ? n10 : this.nextState(byArray, n6, n10, n11);
                n12 = (byArray3[n9 + (n10 >>> 3)] & 0xFF) >>> 7 - (n10 & 7) & 1;
                int n14 = n12 != 0 ? n10 : this.nextState(byArray3, n9, n10, n11);
                int n15 = 0;
                while (true) {
                    int n16;
                    if ((n16 = this.nextState(byArray3, n9, n14, n11)) < n13) {
                        n7 += this.add2DBits(byArray2, n7, pass, 0);
                        n10 = n16;
                    } else {
                        int n17 = n14 - n13 + 3;
                        if (n17 <= 6 && n17 >= 0) {
                            n7 += this.add2DBits(byArray2, n7, vert, n17);
                            n10 = n13;
                        } else {
                            int n18 = this.nextState(byArray, n6, n13, n11);
                            n7 += this.add2DBits(byArray2, n7, horz, 0);
                            n7 += this.add1DBits(byArray2, n7, n13 - n10, n15);
                            n7 += this.add1DBits(byArray2, n7, n18 - n13, n15 ^ 1);
                            n10 = n18;
                        }
                    }
                    if (n10 >= n11) break;
                    n15 = (byArray[n6 + (n10 >>> 3)] & 0xFF) >>> 7 - (n10 & 7) & 1;
                    n13 = this.nextState(byArray, n6, n10, n11);
                    n14 = this.nextState(byArray3, n9, n10, n11);
                    n12 = (byArray3[n9 + (n14 >>> 3)] & 0xFF) >>> 7 - (n14 & 7) & 1;
                    if (n12 != n15) continue;
                    n14 = this.nextState(byArray3, n9, n14, n11);
                }
            }
            n6 += n;
        }
        for (n5 = 0; n5 < 6; ++n5) {
            n7 += this.addEOL(bl, bl2, true, byArray2, n7);
        }
        while (this.ndex > 0) {
            byArray2[n7++] = (byte)(this.bits >>> 24);
            this.bits <<= 8;
            this.ndex -= 8;
        }
        if (this.inverseFill) {
            for (n5 = 0; n5 < n7; ++n5) {
                byArray2[n5] = TIFFFaxDecompressor.flipTable[byArray2[n5] & 0xFF];
            }
        }
        return n7;
    }

    public int encode(byte[] byArray, int n, int n2, int n3, int[] nArray, int n4) throws IOException {
        if (nArray.length != 1 || nArray[0] != 1) {
            throw new IIOException("Bits per sample must be 1 for T4 compression!");
        }
        int n5 = 9 * ((n2 + 1) / 2) + 2;
        int n6 = (n5 + 7) / 8;
        n6 = n3 * (n6 + 2) + 12;
        byte[] byArray2 = new byte[n6];
        int n7 = this.encodeT4(this.is1DMode, this.isEOLAligned, byArray, n4, 8 * n, n2, n3, byArray2);
        this.stream.write(byArray2, 0, n7);
        return n7;
    }
}

