<!DOCTYPE stylesheet [
	<!ENTITY ht "&#09;">
	<!ENTITY cr "&#10;">
	<!ENTITY quark_setup_info "&lt;v2.05&gt;&lt;e0&gt;&cr;">
	<!ENTITY new " &lt;@new star&gt;H&lt;@$p&gt; ">
]>
<!-- 
cgats17 style sheet to convert from xml to text format
updated to second working draft of dtd/schema

matches draft 15 dtd / schema

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:strip-space elements="*"/>
	<!-- begin matching elements -->
	<xsl:template match="cgats17">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="comment">
		<xsl:text>#</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="cgats17.preamble">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="cgats17.data_section">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="cgats17.data_section_header">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="cgats17.data_section_data">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="standard">
		<xsl:apply-templates/>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="originator">
		<xsl:text>ORIGINATOR "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="file_descriptor">
		<xsl:text>FILE_DESCRIPTOR "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="0">
		<xsl:text>CREATED "</xsl:text>
		<xsl:choose>
			<xsl:when test="normalize-space(.)">
				<xsl:apply-templates/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="substring(@date, 6, 2)='01'">January</xsl:when>
					<xsl:when test="substring(@date, 6, 2)='02'">February</xsl:when>
					<xsl:when test="substring(@date, 6, 2)='03'">March</xsl:when>
					<xsl:when test="substring(@date, 6, 2)='04'">April</xsl:when>
					<xsl:when test="substring(@date, 6, 2)='05'">May</xsl:when>
					<xsl:when test="substring(@date, 6, 2)='06'">June</xsl:when>
					<xsl:when test="substring(@date, 6, 2)='07'">July</xsl:when>
					<xsl:when test="substring(@date, 6, 2)='08'">August</xsl:when>
					<xsl:when test="substring(@date, 6, 2)='09'">September</xsl:when>
					<xsl:when test="substring(@date, 6, 2)='10'">October</xsl:when>
					<xsl:when test="substring(@date, 6, 2)='11'">November</xsl:when>
					<xsl:when test="substring(@date, 6, 2)='12'">December</xsl:when>
					<xsl:otherwise>**** no match ??? **** <xsl:value-of select="substring(@date, 5, 2)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring(@date, 9, 2)"/>
				<xsl:text>, </xsl:text>
				<xsl:value-of select="substring(@date, 1, 4)"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="data_format_identifier">
		<xsl:text>DATA_FORMAT_IDENTIFIER "</xsl:text>
		<xsl:value-of select="@name"/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@data_type">
			<xsl:text>(</xsl:text>
			<xsl:value-of select="@data_type"/>
			<xsl:text>)</xsl:text>
		</xsl:if>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="colorant">
		<xsl:text>COLORANT "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="computational_parameter">
		<xsl:text>COMPUTATIONAL_PARAMETER "</xsl:text>
		<xsl:value-of select="@name"/>
		<xsl:text>,</xsl:text>
		<xsl:value-of select="@parameter"/>
		<xsl:text>,</xsl:text>
		<xsl:value-of select="@value"/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="copyright">
		<xsl:text>COPYRIGHT "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="filter">
		<xsl:text>FILTER "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="instrumentation">
		<xsl:text>INSTRUMENTATION "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="keyword">
		<xsl:text>KEYWORD "</xsl:text>
		<xsl:value-of select="@name"/>
		<xsl:text>" </xsl:text>
		<xsl:value-of select="@value"/>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="manufacturer">
		<xsl:text>MANUFACTURER "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="material">
		<xsl:text>MATERIAL "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="measurement_geometry">
		<xsl:text>MEASUREMENT_GEOMETRY "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="measurement_source">
		<xsl:text>MEASUREMENT_SOURCE "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="spot_id">
		<xsl:text>SPOT_ID "</xsl:text>
		<xsl:value-of select="@number"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="@color"/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="polarization">
		<xsl:text>POLARIZATION "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="print_conditions">
		<xsl:text>PRINT_CONDITIONS "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="processcolor_id">
		<xsl:text>PROCESSCOLOR_ID "</xsl:text>
		<xsl:value-of select="@colors_in_set"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="@color_number"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="@color"/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="prod_date">
		<xsl:text>PROD_DATE "</xsl:text>
		<xsl:choose>
			<xsl:when test="normalize-space(.)">
				<xsl:apply-templates/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="@year"/>:<xsl:value-of select="@month"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="sample_backing">
		<xsl:text>SAMPLE_BACKING "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="serial">
		<xsl:text>SERIAL "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="table_descriptor">
		<xsl:text>TABLE_DESCRIPTOR "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="table_name">
		<xsl:text>TABLE_NAME "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="target_type">
		<xsl:text>TARGET_TYPE "</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="weighting_function">
		<xsl:text>WEIGHTING_FUNCTION "</xsl:text>
		<xsl:value-of select="@name"/>
		<xsl:text>, </xsl:text>
		<xsl:value-of select="@value"/>
		<xsl:text>"</xsl:text>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="number_of_fields">
		<xsl:text>NUMBER_OF_FIELDS </xsl:text>
		<xsl:apply-templates/>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="number_of_sets">
		<xsl:text>NUMBER_OF_SETS </xsl:text>
		<xsl:apply-templates/>
		<xsl:if test="@comment">
			<xsl:text> #</xsl:text>
			<xsl:value-of select="@comment"/>
		</xsl:if>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="data_format">
		<xsl:text>BEGIN_DATA_FORMAT&cr;</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>&cr;END_DATA_FORMAT&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="field_info">
		<xsl:value-of select="@name"/>
		<xsl:if test="not(position()=last())">
			<xsl:text> </xsl:text>
		</xsl:if>
	</xsl:template>
	<xsl:template match="table">
		<xsl:text>BEGIN_DATA&cr;</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>END_DATA&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="tr">
		<xsl:apply-templates/>
		<xsl:text>&cr;</xsl:text>
	</xsl:template>
	<xsl:template match="td">
		<xsl:if test="contains(., ' ')">
			<xsl:text>"</xsl:text>
			<xsl:apply-templates/>
			<xsl:text>"</xsl:text>
		</xsl:if>
		<xsl:if test="not(contains(., ' '))">
			<xsl:apply-templates/>
		</xsl:if>
		<xsl:if test="not(position()=last())">
			<xsl:text>&ht;</xsl:text>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
